/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.List;

public class Truncate
extends BuiltStatement {
    private final String table;

    Truncate(String keyspace, String table) {
        this(keyspace, table, null, null);
    }

    Truncate(TableMetadata table) {
        this(Truncate.escapeId(table.getKeyspace().getName()), Truncate.escapeId(table.getName()), new ByteBuffer[table.getPartitionKey().size()], table.getPartitionKey());
    }

    Truncate(String keyspace, String table, ByteBuffer[] routingKey, List<ColumnMetadata> partitionKey) {
        super(keyspace, partitionKey, routingKey);
        this.table = table;
    }

    @Override
    protected StringBuilder buildQueryString(List<Object> variables) {
        StringBuilder builder = new StringBuilder();
        builder.append("TRUNCATE ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        return builder;
    }
}

