/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class DataType {
    protected final Name name;
    private static final Map<Name, DataType> primitiveTypeMap = new EnumMap<Name, DataType>(Name.class);
    private static final Set<DataType> primitiveTypeSet;

    protected DataType(Name name) {
        this.name = name;
    }

    static DataType decode(ByteBuf buffer) {
        Name name = Name.fromProtocolId(buffer.readUnsignedShort());
        switch (name) {
            case CUSTOM: {
                String className = CBUtil.readString(buffer);
                return CassandraTypeParser.isUserType(className) || CassandraTypeParser.isTupleType(className) ? CassandraTypeParser.parseOne(className) : DataType.custom(className);
            }
            case LIST: {
                return DataType.list(DataType.decode(buffer));
            }
            case SET: {
                return DataType.set(DataType.decode(buffer));
            }
            case MAP: {
                DataType keys = DataType.decode(buffer);
                DataType values = DataType.decode(buffer);
                return DataType.map(keys, values);
            }
            case UDT: {
                String keyspace = CBUtil.readString(buffer);
                String type = CBUtil.readString(buffer);
                int nFields = buffer.readShort() & 0xFFFF;
                ArrayList<UserType.Field> fields = new ArrayList<UserType.Field>(nFields);
                for (int i = 0; i < nFields; ++i) {
                    String fieldName = CBUtil.readString(buffer);
                    DataType fieldType = DataType.decode(buffer);
                    fields.add(new UserType.Field(fieldName, fieldType));
                }
                return new UserType(keyspace, type, fields);
            }
            case TUPLE: {
                int nFields = buffer.readShort() & 0xFFFF;
                ArrayList<DataType> types = new ArrayList<DataType>(nFields);
                for (int i = 0; i < nFields; ++i) {
                    types.add(DataType.decode(buffer));
                }
                return new TupleType(types);
            }
        }
        return primitiveTypeMap.get((Object)name);
    }

    abstract TypeCodec<Object> codec(ProtocolVersion var1);

    public static DataType ascii() {
        return primitiveTypeMap.get((Object)Name.ASCII);
    }

    public static DataType bigint() {
        return primitiveTypeMap.get((Object)Name.BIGINT);
    }

    public static DataType blob() {
        return primitiveTypeMap.get((Object)Name.BLOB);
    }

    public static DataType cboolean() {
        return primitiveTypeMap.get((Object)Name.BOOLEAN);
    }

    public static DataType counter() {
        return primitiveTypeMap.get((Object)Name.COUNTER);
    }

    public static DataType decimal() {
        return primitiveTypeMap.get((Object)Name.DECIMAL);
    }

    public static DataType cdouble() {
        return primitiveTypeMap.get((Object)Name.DOUBLE);
    }

    public static DataType cfloat() {
        return primitiveTypeMap.get((Object)Name.FLOAT);
    }

    public static DataType inet() {
        return primitiveTypeMap.get((Object)Name.INET);
    }

    public static DataType cint() {
        return primitiveTypeMap.get((Object)Name.INT);
    }

    public static DataType text() {
        return primitiveTypeMap.get((Object)Name.TEXT);
    }

    public static DataType timestamp() {
        return primitiveTypeMap.get((Object)Name.TIMESTAMP);
    }

    public static DataType uuid() {
        return primitiveTypeMap.get((Object)Name.UUID);
    }

    public static DataType varchar() {
        return primitiveTypeMap.get((Object)Name.VARCHAR);
    }

    public static DataType varint() {
        return primitiveTypeMap.get((Object)Name.VARINT);
    }

    public static DataType timeuuid() {
        return primitiveTypeMap.get((Object)Name.TIMEUUID);
    }

    public static DataType list(DataType elementType, boolean frozen) {
        return new Collection(Name.LIST, ImmutableList.of(elementType), frozen);
    }

    public static DataType list(DataType elementType) {
        return DataType.list(elementType, false);
    }

    public static DataType frozenList(DataType elementType) {
        return DataType.list(elementType, true);
    }

    public static DataType set(DataType elementType, boolean frozen) {
        return new Collection(Name.SET, ImmutableList.of(elementType), frozen);
    }

    public static DataType set(DataType elementType) {
        return DataType.set(elementType, false);
    }

    public static DataType frozenSet(DataType elementType) {
        return DataType.set(elementType, true);
    }

    public static DataType map(DataType keyType, DataType valueType, boolean frozen) {
        return new Collection(Name.MAP, ImmutableList.of(keyType, valueType), frozen);
    }

    public static DataType map(DataType keyType, DataType valueType) {
        return DataType.map(keyType, valueType, false);
    }

    public static DataType frozenMap(DataType keyType, DataType valueType) {
        return DataType.map(keyType, valueType, true);
    }

    public static DataType custom(String typeClassName) {
        if (typeClassName == null) {
            throw new NullPointerException();
        }
        return new Custom(Name.CUSTOM, typeClassName);
    }

    public Name getName() {
        return this.name;
    }

    public abstract boolean isFrozen();

    public List<DataType> getTypeArguments() {
        return Collections.emptyList();
    }

    abstract boolean canBeDeserializedAs(TypeToken var1);

    public String getCustomTypeClassName() {
        return null;
    }

    public Object parse(String value2) {
        return value2 == null ? null : this.codec(ProtocolVersion.NEWEST_SUPPORTED).parse(value2);
    }

    public String format(Object value2) {
        return value2 == null ? null : this.codec(ProtocolVersion.NEWEST_SUPPORTED).format(value2);
    }

    public boolean isCollection() {
        return this.name.isCollection();
    }

    public Class<?> asJavaClass() {
        return this.getName().asJavaClass();
    }

    public static Set<DataType> allPrimitiveTypes() {
        return primitiveTypeSet;
    }

    public ByteBuffer serialize(Object value2, ProtocolVersion protocolVersion) {
        Class<?> providedClass = value2.getClass();
        Class<?> expectedClass = this.asJavaClass();
        if (!expectedClass.isAssignableFrom(providedClass)) {
            throw new InvalidTypeException(String.format("Invalid value for CQL type %s, expecting %s but %s provided", this.toString(), expectedClass, providedClass));
        }
        try {
            return this.codec(protocolVersion).serialize(value2);
        }
        catch (ClassCastException e) {
            throw new InvalidTypeException("Invalid type for collection element: " + e.getMessage());
        }
    }

    @Deprecated
    public ByteBuffer serialize(Object value2, int protocolVersion) {
        return this.serialize(value2, ProtocolVersion.fromInt(protocolVersion));
    }

    @Deprecated
    public ByteBuffer serialize(Object value2) {
        throw new UnsupportedOperationException("Method no longer supported; use serialize(Object,ProtocolVersion)");
    }

    public Object deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        return this.codec(protocolVersion).deserialize(bytes);
    }

    public Object deserialize(ByteBuffer bytes, int protocolVersion) {
        return this.deserialize(bytes, ProtocolVersion.fromInt(protocolVersion));
    }

    @Deprecated
    public Object deserialize(ByteBuffer bytes) {
        throw new UnsupportedOperationException("Method no longer supported; use deserialize(ByteBuffer,ProtocolVersion)");
    }

    public static ByteBuffer serializeValue(Object value2, ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        try {
            DataType dt = TypeCodec.getDataTypeFor(value2);
            return dt.serialize(value2, protocolVersion);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Could not serialize value of type %s", value2.getClass()), e);
        }
        catch (InvalidTypeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Deprecated
    public static ByteBuffer serializeValue(Object value2, int protocolVersion) {
        return DataType.serializeValue(value2, ProtocolVersion.fromInt(protocolVersion));
    }

    @Deprecated
    public static ByteBuffer serializeValue(Object value2) {
        throw new UnsupportedOperationException("Method no longer supported; use serializeValue(Object,ProtocolVersion)");
    }

    static {
        for (Name name : Name.values()) {
            if (name.isCollection() || name == Name.CUSTOM || name == Name.UDT || name == Name.TUPLE) continue;
            primitiveTypeMap.put(name, new Native(name));
        }
        primitiveTypeSet = ImmutableSet.copyOf(primitiveTypeMap.values());
    }

    private static class Custom
    extends DataType {
        private final String customClassName;

        private Custom(Name name, String className) {
            super(name);
            this.customClassName = className;
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        @Override
        boolean canBeDeserializedAs(TypeToken typeToken) {
            return typeToken.getRawType().getName().equals(this.customClassName);
        }

        @Override
        TypeCodec<Object> codec(ProtocolVersion protocolVersion) {
            return TypeCodec.bytesCodec;
        }

        @Override
        public String getCustomTypeClassName() {
            return this.customClassName;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.customClassName});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Custom)) {
                return false;
            }
            Custom d = (Custom)o;
            return this.name == d.name && Objects.equal(this.customClassName, d.customClassName);
        }

        public String toString() {
            return String.format("'%s'", this.customClassName);
        }
    }

    private static class Collection
    extends DataType {
        private final List<DataType> typeArguments;
        private boolean frozen;

        private Collection(Name name, List<DataType> typeArguments, boolean frozen) {
            super(name);
            this.typeArguments = typeArguments;
            this.frozen = frozen;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        boolean canBeDeserializedAs(TypeToken typeToken) {
            switch (this.name) {
                case LIST: {
                    return typeToken.getRawType().isAssignableFrom(List.class) && this.typeArguments.get(0).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[0]));
                }
                case SET: {
                    return typeToken.getRawType().isAssignableFrom(Set.class) && this.typeArguments.get(0).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[0]));
                }
                case MAP: {
                    return typeToken.getRawType().isAssignableFrom(Map.class) && this.typeArguments.get(0).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[0])) && this.typeArguments.get(1).canBeDeserializedAs(typeToken.resolveType(typeToken.getRawType().getTypeParameters()[1]));
                }
            }
            throw new AssertionError();
        }

        @Override
        TypeCodec<Object> codec(ProtocolVersion protocolVersion) {
            switch (this.name) {
                case LIST: {
                    return TypeCodec.listOf(this.typeArguments.get(0), protocolVersion);
                }
                case SET: {
                    return TypeCodec.setOf(this.typeArguments.get(0), protocolVersion);
                }
                case MAP: {
                    return TypeCodec.mapOf(this.typeArguments.get(0), this.typeArguments.get(1), protocolVersion);
                }
            }
            throw new AssertionError();
        }

        @Override
        public List<DataType> getTypeArguments() {
            return this.typeArguments;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.typeArguments});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection d = (Collection)o;
            return this.name == d.name && this.typeArguments.equals(d.typeArguments);
        }

        public String toString() {
            if (this.name == Name.MAP) {
                String template = this.frozen ? "frozen<%s<%s, %s>>" : "%s<%s, %s>";
                return String.format(template, new Object[]{this.name, this.typeArguments.get(0), this.typeArguments.get(1)});
            }
            String template = this.frozen ? "frozen<%s<%s>>" : "%s<%s>";
            return String.format(template, new Object[]{this.name, this.typeArguments.get(0)});
        }
    }

    private static class Native
    extends DataType {
        private Native(Name name) {
            super(name);
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        @Override
        boolean canBeDeserializedAs(TypeToken typeToken) {
            return typeToken.isAssignableFrom(this.getName().javaType);
        }

        @Override
        TypeCodec<Object> codec(ProtocolVersion protocolVersion) {
            return TypeCodec.createFor(this.name);
        }

        public final int hashCode() {
            return this.name == Name.TEXT ? Name.VARCHAR.hashCode() : this.name.hashCode();
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Native)) {
                return false;
            }
            Native that = (Native)o;
            return this.name == that.name || this.name == Name.VARCHAR && that.name == Name.TEXT || this.name == Name.TEXT && that.name == Name.VARCHAR;
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static enum Name {
        ASCII(1, String.class),
        BIGINT(2, Long.class),
        BLOB(3, ByteBuffer.class),
        BOOLEAN(4, Boolean.class),
        COUNTER(5, Long.class),
        DECIMAL(6, BigDecimal.class),
        DOUBLE(7, Double.class),
        FLOAT(8, Float.class),
        INET(16, InetAddress.class),
        INT(9, Integer.class),
        TEXT(10, String.class),
        TIMESTAMP(11, Date.class),
        UUID(12, UUID.class),
        VARCHAR(13, String.class),
        VARINT(14, BigInteger.class),
        TIMEUUID(15, UUID.class),
        LIST(32, List.class),
        SET(34, Set.class),
        MAP(33, Map.class),
        UDT(48, UDTValue.class),
        TUPLE(49, TupleValue.class),
        CUSTOM(0, ByteBuffer.class);

        final int protocolId;
        final Class<?> javaType;
        private static final Name[] nameToIds;

        private Name(int protocolId, Class<?> javaType) {
            this.protocolId = protocolId;
            this.javaType = javaType;
        }

        static Name fromProtocolId(int id) {
            Name name = nameToIds[id];
            if (name == null) {
                throw new DriverInternalError("Unknown data type protocol id: " + id);
            }
            return name;
        }

        public boolean isCollection() {
            switch (this) {
                case LIST: 
                case SET: 
                case MAP: {
                    return true;
                }
            }
            return false;
        }

        public Class<?> asJavaClass() {
            return this.javaType;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        static {
            int maxCode = -1;
            for (Name name : Name.values()) {
                maxCode = Math.max(maxCode, name.protocolId);
            }
            nameToIds = new Name[maxCode + 1];
            for (Name name : Name.values()) {
                if (nameToIds[name.protocolId] != null) {
                    throw new IllegalStateException("Duplicate Id");
                }
                Name.nameToIds[name.protocolId] = name;
            }
        }
    }
}

