/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.github.f4b6a3.uuid.UuidCreator;
import com.github.f4b6a3.uuid.creator.rfc4122.TimeBasedUuidCreator;
import com.github.f4b6a3.uuid.strategy.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.util.UuidTime;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.UUID;

public final class UUIDWrapper {
    private UUIDWrapper() {
    }

    public static UUID generateRepresentationVersion(Instant date, String recordId) {
        CustomNodeIdentifierStrategy nodeIdentifierStrategy = new CustomNodeIdentifierStrategy(recordId);
        TimeBasedUuidCreator uuidCreator = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withNodeIdentifierStrategy((NodeIdentifierStrategy)nodeIdentifierStrategy).withTimestampStrategy(() -> UuidTime.toTimestamp((Instant)date)).withClockSequence(0);
        return uuidCreator.create();
    }

    public static String generateRepresentationFileName(String recordId) {
        return UuidCreator.getNameBasedMd5((String)recordId).toString();
    }

    private static class CustomNodeIdentifierStrategy
    implements NodeIdentifierStrategy {
        private final String recordId;

        public CustomNodeIdentifierStrategy(String recordId) {
            this.recordId = recordId;
        }

        public long getNodeIdentifier() {
            try {
                byte[] sha512 = MessageDigest.getInstance("SHA-512").digest(this.recordId.getBytes(StandardCharsets.UTF_8));
                return ByteBuffer.wrap(sha512).getLong();
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("SHA-512 not supported", e);
            }
        }
    }
}

