/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskInfoDAO;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStatusChecker.class);
    public static final int CHECKING_INTERVAL_IN_MILLISECONDS = 5000;
    public static final int CONCURRENCY_LEVEL = 1000;
    public static final int SIZE = 100;
    private static TaskStatusChecker instance;
    private LoadingCache<Long, Boolean> cache;
    private CassandraTaskInfoDAO taskDAO;

    private TaskStatusChecker(CassandraConnectionProvider cassandraConnectionProvider) {
        this(CassandraTaskInfoDAO.getInstance(cassandraConnectionProvider), 5000);
    }

    public TaskStatusChecker(CassandraTaskInfoDAO taskDAO) {
        this(taskDAO, 5000);
    }

    protected TaskStatusChecker(CassandraTaskInfoDAO taskDAO, int checkingInterval) {
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite((long)checkingInterval, TimeUnit.MILLISECONDS).concurrencyLevel(1000).maximumSize(100L).softValues().build((CacheLoader)new CacheLoader<Long, Boolean>(){

            public Boolean load(Long taskId) throws TaskInfoDoesNotExistException {
                return TaskStatusChecker.this.isDroppedTask(taskId);
            }
        });
        this.taskDAO = taskDAO;
    }

    public static synchronized TaskStatusChecker getTaskStatusChecker(CassandraConnectionProvider cassandraConnectionProvider) {
        if (instance == null) {
            instance = new TaskStatusChecker(cassandraConnectionProvider);
        }
        return instance;
    }

    public boolean hasDroppedStatus(long taskId) {
        try {
            return (Boolean)this.cache.get((Object)taskId);
        }
        catch (ExecutionException e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }

    private Boolean isDroppedTask(long taskId) throws TaskInfoDoesNotExistException {
        LOGGER.info("Checking the task status for the task id from backend: {}", (Object)taskId);
        return this.taskDAO.isDroppedTask(taskId);
    }
}

