/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.Row;
import java.util.Date;
import java.util.UUID;

public class HarvestedRecord {
    private String metisDatasetId;
    private String recordLocalId;
    private int bucketNumber;
    private Date latestHarvestDate;
    private UUID latestHarvestMd5;
    private Date previewHarvestDate;
    private UUID previewHarvestMd5;
    private Date publishedHarvestDate;
    private UUID publishedHarvestMd5;

    public static HarvestedRecord from(Row row) {
        return HarvestedRecord.builder().metisDatasetId(row.getString("metis_dataset_id")).recordLocalId(row.getString("record_local_id")).bucketNumber(row.getInt("bucket_number")).latestHarvestDate(row.getTimestamp("latest_harvest_date")).latestHarvestMd5(row.getUUID("latest_harvest_md5")).previewHarvestDate(row.getTimestamp("preview_harvest_date")).previewHarvestMd5(row.getUUID("preview_harvest_md5")).publishedHarvestDate(row.getTimestamp("published_harvest_date")).publishedHarvestMd5(row.getUUID("published_harvest_md5")).build();
    }

    HarvestedRecord(String metisDatasetId, String recordLocalId, int bucketNumber, Date latestHarvestDate, UUID latestHarvestMd5, Date previewHarvestDate, UUID previewHarvestMd5, Date publishedHarvestDate, UUID publishedHarvestMd5) {
        this.metisDatasetId = metisDatasetId;
        this.recordLocalId = recordLocalId;
        this.bucketNumber = bucketNumber;
        this.latestHarvestDate = latestHarvestDate;
        this.latestHarvestMd5 = latestHarvestMd5;
        this.previewHarvestDate = previewHarvestDate;
        this.previewHarvestMd5 = previewHarvestMd5;
        this.publishedHarvestDate = publishedHarvestDate;
        this.publishedHarvestMd5 = publishedHarvestMd5;
    }

    public static HarvestedRecordBuilder builder() {
        return new HarvestedRecordBuilder();
    }

    public String getMetisDatasetId() {
        return this.metisDatasetId;
    }

    public String getRecordLocalId() {
        return this.recordLocalId;
    }

    public int getBucketNumber() {
        return this.bucketNumber;
    }

    public Date getLatestHarvestDate() {
        return this.latestHarvestDate;
    }

    public UUID getLatestHarvestMd5() {
        return this.latestHarvestMd5;
    }

    public Date getPreviewHarvestDate() {
        return this.previewHarvestDate;
    }

    public UUID getPreviewHarvestMd5() {
        return this.previewHarvestMd5;
    }

    public Date getPublishedHarvestDate() {
        return this.publishedHarvestDate;
    }

    public UUID getPublishedHarvestMd5() {
        return this.publishedHarvestMd5;
    }

    public void setMetisDatasetId(String metisDatasetId) {
        this.metisDatasetId = metisDatasetId;
    }

    public void setRecordLocalId(String recordLocalId) {
        this.recordLocalId = recordLocalId;
    }

    public void setBucketNumber(int bucketNumber) {
        this.bucketNumber = bucketNumber;
    }

    public void setLatestHarvestDate(Date latestHarvestDate) {
        this.latestHarvestDate = latestHarvestDate;
    }

    public void setLatestHarvestMd5(UUID latestHarvestMd5) {
        this.latestHarvestMd5 = latestHarvestMd5;
    }

    public void setPreviewHarvestDate(Date previewHarvestDate) {
        this.previewHarvestDate = previewHarvestDate;
    }

    public void setPreviewHarvestMd5(UUID previewHarvestMd5) {
        this.previewHarvestMd5 = previewHarvestMd5;
    }

    public void setPublishedHarvestDate(Date publishedHarvestDate) {
        this.publishedHarvestDate = publishedHarvestDate;
    }

    public void setPublishedHarvestMd5(UUID publishedHarvestMd5) {
        this.publishedHarvestMd5 = publishedHarvestMd5;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HarvestedRecord)) {
            return false;
        }
        HarvestedRecord other = (HarvestedRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBucketNumber() != other.getBucketNumber()) {
            return false;
        }
        String this$metisDatasetId = this.getMetisDatasetId();
        String other$metisDatasetId = other.getMetisDatasetId();
        if (this$metisDatasetId == null ? other$metisDatasetId != null : !this$metisDatasetId.equals(other$metisDatasetId)) {
            return false;
        }
        String this$recordLocalId = this.getRecordLocalId();
        String other$recordLocalId = other.getRecordLocalId();
        if (this$recordLocalId == null ? other$recordLocalId != null : !this$recordLocalId.equals(other$recordLocalId)) {
            return false;
        }
        Date this$latestHarvestDate = this.getLatestHarvestDate();
        Date other$latestHarvestDate = other.getLatestHarvestDate();
        if (this$latestHarvestDate == null ? other$latestHarvestDate != null : !((Object)this$latestHarvestDate).equals(other$latestHarvestDate)) {
            return false;
        }
        UUID this$latestHarvestMd5 = this.getLatestHarvestMd5();
        UUID other$latestHarvestMd5 = other.getLatestHarvestMd5();
        if (this$latestHarvestMd5 == null ? other$latestHarvestMd5 != null : !((Object)this$latestHarvestMd5).equals(other$latestHarvestMd5)) {
            return false;
        }
        Date this$previewHarvestDate = this.getPreviewHarvestDate();
        Date other$previewHarvestDate = other.getPreviewHarvestDate();
        if (this$previewHarvestDate == null ? other$previewHarvestDate != null : !((Object)this$previewHarvestDate).equals(other$previewHarvestDate)) {
            return false;
        }
        UUID this$previewHarvestMd5 = this.getPreviewHarvestMd5();
        UUID other$previewHarvestMd5 = other.getPreviewHarvestMd5();
        if (this$previewHarvestMd5 == null ? other$previewHarvestMd5 != null : !((Object)this$previewHarvestMd5).equals(other$previewHarvestMd5)) {
            return false;
        }
        Date this$publishedHarvestDate = this.getPublishedHarvestDate();
        Date other$publishedHarvestDate = other.getPublishedHarvestDate();
        if (this$publishedHarvestDate == null ? other$publishedHarvestDate != null : !((Object)this$publishedHarvestDate).equals(other$publishedHarvestDate)) {
            return false;
        }
        UUID this$publishedHarvestMd5 = this.getPublishedHarvestMd5();
        UUID other$publishedHarvestMd5 = other.getPublishedHarvestMd5();
        return !(this$publishedHarvestMd5 == null ? other$publishedHarvestMd5 != null : !((Object)this$publishedHarvestMd5).equals(other$publishedHarvestMd5));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HarvestedRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBucketNumber();
        String $metisDatasetId = this.getMetisDatasetId();
        result = result * 59 + ($metisDatasetId == null ? 43 : $metisDatasetId.hashCode());
        String $recordLocalId = this.getRecordLocalId();
        result = result * 59 + ($recordLocalId == null ? 43 : $recordLocalId.hashCode());
        Date $latestHarvestDate = this.getLatestHarvestDate();
        result = result * 59 + ($latestHarvestDate == null ? 43 : ((Object)$latestHarvestDate).hashCode());
        UUID $latestHarvestMd5 = this.getLatestHarvestMd5();
        result = result * 59 + ($latestHarvestMd5 == null ? 43 : ((Object)$latestHarvestMd5).hashCode());
        Date $previewHarvestDate = this.getPreviewHarvestDate();
        result = result * 59 + ($previewHarvestDate == null ? 43 : ((Object)$previewHarvestDate).hashCode());
        UUID $previewHarvestMd5 = this.getPreviewHarvestMd5();
        result = result * 59 + ($previewHarvestMd5 == null ? 43 : ((Object)$previewHarvestMd5).hashCode());
        Date $publishedHarvestDate = this.getPublishedHarvestDate();
        result = result * 59 + ($publishedHarvestDate == null ? 43 : ((Object)$publishedHarvestDate).hashCode());
        UUID $publishedHarvestMd5 = this.getPublishedHarvestMd5();
        result = result * 59 + ($publishedHarvestMd5 == null ? 43 : ((Object)$publishedHarvestMd5).hashCode());
        return result;
    }

    public String toString() {
        return "HarvestedRecord(metisDatasetId=" + this.getMetisDatasetId() + ", recordLocalId=" + this.getRecordLocalId() + ", bucketNumber=" + this.getBucketNumber() + ", latestHarvestDate=" + String.valueOf(this.getLatestHarvestDate()) + ", latestHarvestMd5=" + String.valueOf(this.getLatestHarvestMd5()) + ", previewHarvestDate=" + String.valueOf(this.getPreviewHarvestDate()) + ", previewHarvestMd5=" + String.valueOf(this.getPreviewHarvestMd5()) + ", publishedHarvestDate=" + String.valueOf(this.getPublishedHarvestDate()) + ", publishedHarvestMd5=" + String.valueOf(this.getPublishedHarvestMd5()) + ")";
    }

    public static class HarvestedRecordBuilder {
        private String metisDatasetId;
        private String recordLocalId;
        private int bucketNumber;
        private Date latestHarvestDate;
        private UUID latestHarvestMd5;
        private Date previewHarvestDate;
        private UUID previewHarvestMd5;
        private Date publishedHarvestDate;
        private UUID publishedHarvestMd5;

        HarvestedRecordBuilder() {
        }

        public HarvestedRecordBuilder metisDatasetId(String metisDatasetId) {
            this.metisDatasetId = metisDatasetId;
            return this;
        }

        public HarvestedRecordBuilder recordLocalId(String recordLocalId) {
            this.recordLocalId = recordLocalId;
            return this;
        }

        public HarvestedRecordBuilder bucketNumber(int bucketNumber) {
            this.bucketNumber = bucketNumber;
            return this;
        }

        public HarvestedRecordBuilder latestHarvestDate(Date latestHarvestDate) {
            this.latestHarvestDate = latestHarvestDate;
            return this;
        }

        public HarvestedRecordBuilder latestHarvestMd5(UUID latestHarvestMd5) {
            this.latestHarvestMd5 = latestHarvestMd5;
            return this;
        }

        public HarvestedRecordBuilder previewHarvestDate(Date previewHarvestDate) {
            this.previewHarvestDate = previewHarvestDate;
            return this;
        }

        public HarvestedRecordBuilder previewHarvestMd5(UUID previewHarvestMd5) {
            this.previewHarvestMd5 = previewHarvestMd5;
            return this;
        }

        public HarvestedRecordBuilder publishedHarvestDate(Date publishedHarvestDate) {
            this.publishedHarvestDate = publishedHarvestDate;
            return this;
        }

        public HarvestedRecordBuilder publishedHarvestMd5(UUID publishedHarvestMd5) {
            this.publishedHarvestMd5 = publishedHarvestMd5;
            return this;
        }

        public HarvestedRecord build() {
            return new HarvestedRecord(this.metisDatasetId, this.recordLocalId, this.bucketNumber, this.latestHarvestDate, this.latestHarvestMd5, this.previewHarvestDate, this.previewHarvestMd5, this.publishedHarvestDate, this.publishedHarvestMd5);
        }

        public String toString() {
            return "HarvestedRecord.HarvestedRecordBuilder(metisDatasetId=" + this.metisDatasetId + ", recordLocalId=" + this.recordLocalId + ", bucketNumber=" + this.bucketNumber + ", latestHarvestDate=" + String.valueOf(this.latestHarvestDate) + ", latestHarvestMd5=" + String.valueOf(this.latestHarvestMd5) + ", previewHarvestDate=" + String.valueOf(this.previewHarvestDate) + ", previewHarvestMd5=" + String.valueOf(this.previewHarvestMd5) + ", publishedHarvestDate=" + String.valueOf(this.publishedHarvestDate) + ", publishedHarvestMd5=" + String.valueOf(this.publishedHarvestMd5) + ")";
        }
    }
}

