/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.service;

import eu.europeana.cloud.common.model.dps.ErrorDetails;
import eu.europeana.cloud.common.model.dps.ErrorNotification;
import eu.europeana.cloud.common.model.dps.Notification;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.service.dps.TaskExecutionReportService;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.ErrorType;
import eu.europeana.cloud.service.dps.storm.conversion.SubTaskInfoConverter;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskErrorsDAO;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.dao.NotificationsDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class TaskExecutionReportServiceImpl
implements TaskExecutionReportService {
    private static final String RETRIEVING_ERROR_MESSAGE = "Specified task or error type does not exist!";
    private static final String TASK_NOT_EXISTS_ERROR_MESSAGE = "The task with the provided id doesn't exist!";
    private static final int FETCH_ONE = 1;
    private final NotificationsDAO notificationsDAO;
    private final CassandraTaskErrorsDAO taskErrorsDAO;
    private final CassandraTaskInfoDAO taskInfoDAO;

    public TaskExecutionReportServiceImpl(NotificationsDAO notificationsDAO, CassandraTaskErrorsDAO taskErrorsDAO, CassandraTaskInfoDAO taskInfoDAO) {
        this.taskErrorsDAO = taskErrorsDAO;
        this.notificationsDAO = notificationsDAO;
        this.taskInfoDAO = taskInfoDAO;
    }

    public TaskInfo getTaskProgress(long taskId) throws AccessDeniedOrObjectDoesNotExistException {
        Optional<TaskInfo> taskInfo = this.taskInfoDAO.findById(taskId);
        return taskInfo.orElseThrow(() -> new AccessDeniedOrObjectDoesNotExistException(TASK_NOT_EXISTS_ERROR_MESSAGE));
    }

    public void checkIfTaskExists(long taskId, String topologyName) throws AccessDeniedOrObjectDoesNotExistException {
        Optional<TaskInfo> taskInfo = this.taskInfoDAO.findById(taskId);
        if (taskInfo.isEmpty() || !taskInfo.get().getTopologyName().equals(topologyName)) {
            throw new AccessDeniedOrObjectDoesNotExistException(RETRIEVING_ERROR_MESSAGE);
        }
    }

    public boolean checkIfReportExists(long taskId) {
        return !this.taskErrorsDAO.getErrorTypes(taskId).isEmpty();
    }

    public List<SubTaskInfo> getDetailedTaskReport(long taskId, int from, int to) {
        ArrayList<SubTaskInfo> result = new ArrayList<SubTaskInfo>();
        for (int i = NotificationsDAO.bucketNumber(to); i >= NotificationsDAO.bucketNumber(from); --i) {
            List<Notification> notifications = this.notificationsDAO.getNotificationsFromGivenBucketAndWithinGivenResourceNumRange(taskId, from, to, i);
            notifications.forEach(notification -> result.add(SubTaskInfoConverter.fromNotification(notification)));
        }
        return result;
    }

    public TaskErrorsInfo getSpecificTaskErrorReport(long taskId, String errorType, int idsCount) throws AccessDeniedOrObjectDoesNotExistException {
        TaskErrorInfo taskErrorInfo = this.getTaskErrorInfo(taskId, errorType);
        taskErrorInfo.setErrorDetails(this.retrieveErrorDetails(taskId, errorType, idsCount));
        String message = this.getErrorMessage(taskId, new HashMap<String, String>(), errorType);
        taskErrorInfo.setMessage(message);
        return new TaskErrorsInfo(taskId, List.of(taskErrorInfo));
    }

    public TaskErrorsInfo getGeneralTaskErrorReport(long taskId, int idsCount) throws AccessDeniedOrObjectDoesNotExistException {
        ArrayList<TaskErrorInfo> errors = new ArrayList<TaskErrorInfo>();
        TaskErrorsInfo result = new TaskErrorsInfo(taskId, errors);
        List<ErrorType> errorTypes = this.taskErrorsDAO.getErrorTypes(taskId);
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        for (ErrorType errorType : errorTypes) {
            String uuid = errorType.getUuid();
            String message = this.getErrorMessage(taskId, errorMessages, uuid);
            List<ErrorDetails> errorDetails = this.retrieveErrorDetails(taskId, uuid, idsCount);
            errors.add(new TaskErrorInfo(uuid, message, errorType.getCount(), errorDetails));
        }
        return result;
    }

    private List<ErrorDetails> retrieveErrorDetails(long taskId, String errorType, int idsCount) throws AccessDeniedOrObjectDoesNotExistException {
        ArrayList<ErrorDetails> errorDetails = new ArrayList<ErrorDetails>();
        if (idsCount == 0) {
            return errorDetails;
        }
        List<ErrorNotification> errorNotifications = this.taskErrorsDAO.getErrorNotificationsWithGivenLimit(taskId, UUID.fromString(errorType), idsCount);
        if (errorNotifications.isEmpty()) {
            throw new AccessDeniedOrObjectDoesNotExistException(RETRIEVING_ERROR_MESSAGE);
        }
        errorNotifications.forEach(errorNotification -> errorDetails.add(new ErrorDetails(errorNotification.getResource(), errorNotification.getAdditionalInformations())));
        return errorDetails;
    }

    private String getErrorMessage(long taskId, Map<String, String> errorMessages, String errorType) throws AccessDeniedOrObjectDoesNotExistException {
        String message = errorMessages.get(errorType);
        if (message == null) {
            List<ErrorNotification> errorNotifications = this.taskErrorsDAO.getErrorNotificationsWithGivenLimit(taskId, UUID.fromString(errorType), 1);
            if (errorNotifications.isEmpty()) {
                throw new AccessDeniedOrObjectDoesNotExistException(RETRIEVING_ERROR_MESSAGE);
            }
            message = errorNotifications.get(0).getErrorMessage();
            errorMessages.put(errorType, message);
        }
        return message;
    }

    private TaskErrorInfo getTaskErrorInfo(long taskId, String errorType) throws AccessDeniedOrObjectDoesNotExistException {
        return this.taskErrorsDAO.getErrorType(taskId, UUID.fromString(errorType)).map(eT -> TaskErrorInfo.builder().errorType(errorType).occurrences(eT.getCount()).build()).orElseThrow(() -> new AccessDeniedOrObjectDoesNotExistException(RETRIEVING_ERROR_MESSAGE));
    }
}

