/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.incremental;

import eu.europeana.cloud.service.dps.storm.incremental.CategorizationParameters;
import eu.europeana.cloud.service.dps.storm.utils.HarvestedRecord;

public class CategorizationResult {
    private final Category category;
    private final CategorizationParameters categorizationParameters;
    private final HarvestedRecord harvestedRecord;

    public boolean shouldBeProcessed() {
        return this.category.equals((Object)Category.ELIGIBLE_FOR_PROCESSING);
    }

    public boolean shouldBeDropped() {
        return this.category.equals((Object)Category.ALREADY_PROCESSED);
    }

    CategorizationResult(Category category, CategorizationParameters categorizationParameters, HarvestedRecord harvestedRecord) {
        this.category = category;
        this.categorizationParameters = categorizationParameters;
        this.harvestedRecord = harvestedRecord;
    }

    public static CategorizationResultBuilder builder() {
        return new CategorizationResultBuilder();
    }

    public Category getCategory() {
        return this.category;
    }

    public CategorizationParameters getCategorizationParameters() {
        return this.categorizationParameters;
    }

    public HarvestedRecord getHarvestedRecord() {
        return this.harvestedRecord;
    }

    public static enum Category {
        ELIGIBLE_FOR_PROCESSING,
        ALREADY_PROCESSED;

    }

    public static class CategorizationResultBuilder {
        private Category category;
        private CategorizationParameters categorizationParameters;
        private HarvestedRecord harvestedRecord;

        CategorizationResultBuilder() {
        }

        public CategorizationResultBuilder category(Category category) {
            this.category = category;
            return this;
        }

        public CategorizationResultBuilder categorizationParameters(CategorizationParameters categorizationParameters) {
            this.categorizationParameters = categorizationParameters;
            return this;
        }

        public CategorizationResultBuilder harvestedRecord(HarvestedRecord harvestedRecord) {
            this.harvestedRecord = harvestedRecord;
            return this;
        }

        public CategorizationResult build() {
            return new CategorizationResult(this.category, this.categorizationParameters, this.harvestedRecord);
        }

        public String toString() {
            return "CategorizationResult.CategorizationResultBuilder(category=" + String.valueOf((Object)this.category) + ", categorizationParameters=" + String.valueOf(this.categorizationParameters) + ", harvestedRecord=" + String.valueOf(this.harvestedRecord) + ")";
        }
    }
}

