/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.incremental;

import java.time.Instant;
import java.util.UUID;

public class CategorizationParameters {
    private final boolean fullHarvest;
    private final String datasetId;
    private final String recordId;
    private final UUID recordMd5;
    private final Instant recordDateStamp;
    private final Instant currentHarvestDate;

    CategorizationParameters(boolean fullHarvest, String datasetId, String recordId, UUID recordMd5, Instant recordDateStamp, Instant currentHarvestDate) {
        this.fullHarvest = fullHarvest;
        this.datasetId = datasetId;
        this.recordId = recordId;
        this.recordMd5 = recordMd5;
        this.recordDateStamp = recordDateStamp;
        this.currentHarvestDate = currentHarvestDate;
    }

    public static CategorizationParametersBuilder builder() {
        return new CategorizationParametersBuilder();
    }

    public boolean isFullHarvest() {
        return this.fullHarvest;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public UUID getRecordMd5() {
        return this.recordMd5;
    }

    public Instant getRecordDateStamp() {
        return this.recordDateStamp;
    }

    public Instant getCurrentHarvestDate() {
        return this.currentHarvestDate;
    }

    public String toString() {
        return "CategorizationParameters(fullHarvest=" + this.isFullHarvest() + ", datasetId=" + this.getDatasetId() + ", recordId=" + this.getRecordId() + ", recordMd5=" + String.valueOf(this.getRecordMd5()) + ", recordDateStamp=" + String.valueOf(this.getRecordDateStamp()) + ", currentHarvestDate=" + String.valueOf(this.getCurrentHarvestDate()) + ")";
    }

    public static class CategorizationParametersBuilder {
        private boolean fullHarvest;
        private String datasetId;
        private String recordId;
        private UUID recordMd5;
        private Instant recordDateStamp;
        private Instant currentHarvestDate;

        CategorizationParametersBuilder() {
        }

        public CategorizationParametersBuilder fullHarvest(boolean fullHarvest) {
            this.fullHarvest = fullHarvest;
            return this;
        }

        public CategorizationParametersBuilder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public CategorizationParametersBuilder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public CategorizationParametersBuilder recordMd5(UUID recordMd5) {
            this.recordMd5 = recordMd5;
            return this;
        }

        public CategorizationParametersBuilder recordDateStamp(Instant recordDateStamp) {
            this.recordDateStamp = recordDateStamp;
            return this;
        }

        public CategorizationParametersBuilder currentHarvestDate(Instant currentHarvestDate) {
            this.currentHarvestDate = currentHarvestDate;
            return this;
        }

        public CategorizationParameters build() {
            return new CategorizationParameters(this.fullHarvest, this.datasetId, this.recordId, this.recordMd5, this.recordDateStamp, this.currentHarvestDate);
        }

        public String toString() {
            return "CategorizationParameters.CategorizationParametersBuilder(fullHarvest=" + this.fullHarvest + ", datasetId=" + this.datasetId + ", recordId=" + this.recordId + ", recordMd5=" + String.valueOf(this.recordMd5) + ", recordDateStamp=" + String.valueOf(this.recordDateStamp) + ", currentHarvestDate=" + String.valueOf(this.currentHarvestDate) + ")";
        }
    }
}

