/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.TaskByTaskState;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;

@Retryable(maxAttempts=7)
public class TasksByStateDAO
extends CassandraDAO {
    private static TasksByStateDAO instance;
    private PreparedStatement insertStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement findTasksByStateStatement;
    private PreparedStatement findTasksByStateAndTopologyStatement;
    private PreparedStatement findTaskByStateAndTopologyStatement;
    private PreparedStatement findTaskByStateStatement;
    private PreparedStatement findTaskStatement;

    public TasksByStateDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public TasksByStateDAO() {
    }

    public static synchronized TasksByStateDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (TasksByStateDAO)RetryableMethodExecutor.createRetryProxy((Object)new TasksByStateDAO(cassandra));
        }
        return instance;
    }

    @Override
    protected void prepareStatements() {
        this.insertStatement = this.dbService.getSession().prepare("INSERT INTO tasks_by_task_state(state,topology_name,task_id,application_id,topic_name,start_time) VALUES (?,?,?,?,?,?)");
        this.deleteStatement = this.dbService.getSession().prepare("DELETE FROM tasks_by_task_state WHERE state = ? AND topology_name = ? AND task_id = ?");
        this.findTaskStatement = this.dbService.getSession().prepare("SELECT * FROM tasks_by_task_state WHERE state = ? AND topology_name = ? AND task_id = ?");
        this.findTasksByStateStatement = this.dbService.getSession().prepare("SELECT * FROM tasks_by_task_state WHERE state IN ?");
        this.findTasksByStateAndTopologyStatement = this.dbService.getSession().prepare("SELECT *  FROM tasks_by_task_state WHERE state IN ? AND topology_name = ?");
        this.findTaskByStateStatement = this.dbService.getSession().prepare(String.format("select * from %s where %s in ? limit 1", "tasks_by_task_state", "state"));
        this.findTaskByStateAndTopologyStatement = this.dbService.getSession().prepare("SELECT *  FROM tasks_by_task_state WHERE state IN ? AND topology_name = ? LIMIT 1");
    }

    public void insert(TaskState state, String topologyName, long taskId, String applicationId, String topicName, Date startTime) {
        this.dbService.getSession().execute((Statement)this.insertStatement(state, topologyName, taskId, applicationId, topicName, startTime));
    }

    public BoundStatement insertStatement(TaskState state, String topologyName, long taskId, String applicationId, String topicName, Date startTime) {
        return this.insertStatement.bind(new Object[]{state.toString(), topologyName, taskId, applicationId, topicName, startTime});
    }

    public void delete(TaskState state, String topologyName, long taskId) {
        this.dbService.getSession().execute((Statement)this.deleteStatement(state, topologyName, taskId));
    }

    public BoundStatement deleteStatement(TaskState state, String topologyName, long taskId) {
        return this.deleteStatement.bind(new Object[]{state.toString(), topologyName, taskId});
    }

    public Optional<TaskByTaskState> findTask(TaskState state, String topologyName, long taskId) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.findTaskStatement.bind(new Object[]{state.toString(), topologyName, taskId}));
        return Optional.ofNullable(rs.one()).map(this::createTaskByTaskState);
    }

    public List<TaskByTaskState> findTasksByState(List<TaskState> taskStates) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.findTasksByStateStatement.bind(new Object[]{taskStates.stream().map(Enum::toString).toList()}));
        return rs.all().stream().map(this::createTaskByTaskState).toList();
    }

    public List<TaskByTaskState> findTasksByStateAndTopology(List<TaskState> taskStates, String topologyName) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.findTasksByStateAndTopologyStatement.bind(new Object[]{taskStates.stream().map(Enum::toString).toList(), topologyName}));
        return rs.all().stream().map(this::createTaskByTaskState).toList();
    }

    public Optional<TaskByTaskState> findTaskByState(List<TaskState> taskStates) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.findTaskByStateStatement.bind(new Object[]{taskStates.stream().map(Enum::toString).toList()}));
        return Optional.ofNullable(rs.one()).map(this::createTaskByTaskState);
    }

    public Optional<TaskByTaskState> findTaskByStateAndTopology(List<TaskState> taskStates, String topologyName) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.findTaskByStateAndTopologyStatement.bind(new Object[]{taskStates.stream().map(Enum::toString).toList(), topologyName}));
        return Optional.ofNullable(rs.one()).map(this::createTaskByTaskState);
    }

    private TaskByTaskState createTaskByTaskState(Row row) {
        return TaskByTaskState.builder().state((TaskState)EnumUtils.getEnum(TaskState.class, (String)row.getString("state"))).topologyName(row.getString("topology_name")).id(Long.valueOf(row.getLong("task_id"))).applicationId(row.getString("application_id")).startTime(row.getTimestamp("start_time")).topicName(row.getString("topic_name")).build();
    }
}

