/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.GeneralStatistics;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.List;

@Retryable(maxAttempts=7)
public class GeneralStatisticsDAO
extends CassandraDAO {
    private static GeneralStatisticsDAO instance = null;
    private PreparedStatement updateStatement;
    private PreparedStatement removeGeneralStatisticsStatement;
    private PreparedStatement searchGeneralStatistcsByTaskIdStatement;

    public GeneralStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public GeneralStatisticsDAO() {
    }

    public static synchronized GeneralStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (GeneralStatisticsDAO)RetryableMethodExecutor.createRetryProxy((Object)new GeneralStatisticsDAO(cassandra));
        }
        return instance;
    }

    @Override
    protected void prepareStatements() {
        this.updateStatement = this.dbService.getSession().prepare("UPDATE general_statistics SET occurrence = occurrence + 1 WHERE task_id = ? AND parent_xpath = ? AND node_xpath = ?");
        this.removeGeneralStatisticsStatement = this.dbService.getSession().prepare("DELETE FROM general_statistics WHERE task_id = ?");
        this.searchGeneralStatistcsByTaskIdStatement = this.dbService.getSession().prepare("SELECT * FROM general_statistics WHERE task_id = ?");
    }

    public void updateGeneralStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.dbService.getSession().execute((Statement)this.updateStatement.bind(new Object[]{taskId, nodeStatistics.getParentXpath(), nodeStatistics.getXpath()}));
    }

    public void removeGeneralStatistics(long taskId) {
        this.dbService.getSession().execute((Statement)this.removeGeneralStatisticsStatement.bind(new Object[]{taskId}));
    }

    public List<GeneralStatistics> searchGeneralStatistics(long taskId) {
        return this.dbService.getSession().execute((Statement)this.searchGeneralStatistcsByTaskIdStatement.bind(new Object[]{taskId})).all().stream().map(this::createGeneralStatistics).toList();
    }

    private GeneralStatistics createGeneralStatistics(Row row) {
        return GeneralStatistics.builder().parentXpath(row.getString("parent_xpath")).nodeXpath(row.getString("node_xpath")).occurrence(Long.valueOf(row.getLong("occurrence"))).build();
    }
}

