/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.service.commons.utils.DateHelper;
import eu.europeana.cloud.service.dps.OAIPMHHarvestingDetails;
import eu.europeana.enrichment.rest.client.report.Report;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class StormTaskTuple
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BATCH_MAX_SIZE = 4096;
    private long taskId;
    private String taskName;
    private String fileUrl;
    private byte[] fileData;
    private Map<String, String> parameters;
    private Revision revisionToBeApplied;
    private OAIPMHHarvestingDetails sourceDetails;
    private int recordAttemptNumber;
    private Set<Report> reportSet;
    private String throttlingGroupingAttribute;

    public StormTaskTuple() {
        this(0L, "", null, null, new HashMap<String, String>(), null);
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revisionToBeApplied) {
        this(taskId, taskName, fileUrl, fileData, parameters, revisionToBeApplied, null);
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revisionToBeApplied, OAIPMHHarvestingDetails sourceDetails) {
        this(taskId, taskName, fileUrl, fileData, parameters, revisionToBeApplied, sourceDetails, 0, new HashSet<Report>());
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revisionToBeApplied, OAIPMHHarvestingDetails sourceDetails, int recordAttemptNumber, Set<Report> reports) {
        this(taskId, taskName, fileUrl, fileData, parameters, revisionToBeApplied, sourceDetails, recordAttemptNumber, reports, null);
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revisionToBeApplied, OAIPMHHarvestingDetails sourceDetails, int recordAttemptNumber, Set<Report> reportSet, String throttlingGroupingAttribute) {
        this.taskId = taskId;
        this.taskName = taskName;
        this.fileUrl = fileUrl;
        this.fileData = fileData;
        this.parameters = parameters;
        this.revisionToBeApplied = revisionToBeApplied;
        this.sourceDetails = sourceDetails;
        this.recordAttemptNumber = recordAttemptNumber;
        this.reportSet = reportSet;
        this.throttlingGroupingAttribute = throttlingGroupingAttribute;
    }

    public ByteArrayInputStream getFileByteDataAsStream() {
        if (this.fileData != null) {
            return new ByteArrayInputStream(this.fileData);
        }
        return null;
    }

    public static StormTaskTuple fromStormTuple(Tuple tuple) {
        return StormTaskTuple.builder().taskId(tuple.getLongByField("TASK_ID")).taskName(tuple.getStringByField("TASK_NAME")).fileUrl(tuple.getStringByField("INPUT_FILES")).fileData(tuple.getBinaryByField("FILE_CONTENT")).parameters((HashMap)tuple.getValueByField("PARAMETERS")).revisionToBeApplied((Revision)tuple.getValueByField("REVISIONS")).sourceDetails((OAIPMHHarvestingDetails)tuple.getValueByField("SOURCE")).recordAttemptNumber(tuple.getIntegerByField("RECORD_ATTEMPT_NUMBER")).reportSet((HashSet)tuple.getValueByField("REPORT_SET")).build();
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileData(InputStream is) throws IOException {
        try (ByteArrayOutputStream tempByteArrayOutputStream = new ByteArrayOutputStream();){
            if (is != null) {
                byte[] buffer = new byte[4096];
                IOUtils.copyLarge((InputStream)is, (OutputStream)tempByteArrayOutputStream, (byte[])buffer);
                this.fileData = tempByteArrayOutputStream.toByteArray();
            } else {
                this.fileData = null;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void addParameter(String parameterKey, String parameterValue) {
        this.parameters.put(parameterKey, parameterValue);
    }

    public String getParameter(String parameterKey) {
        return this.parameters.get(parameterKey);
    }

    public boolean hasRevisionToBeApplied() {
        return this.revisionToBeApplied != null;
    }

    public static StormTaskTuple fromValues(List<Object> list) {
        return StormTaskTuple.builder().taskId((Long)list.get(0)).taskName((String)list.get(1)).fileUrl((String)list.get(2)).fileData((byte[])list.get(3)).parameters((Map)list.get(4)).revisionToBeApplied((Revision)list.get(5)).sourceDetails((OAIPMHHarvestingDetails)list.get(6)).recordAttemptNumber((Integer)list.get(7)).reportSet((HashSet)list.get(8)).build();
    }

    public static Fields getFields() {
        return new Fields(new String[]{"TASK_ID", "TASK_NAME", "INPUT_FILES", "FILE_CONTENT", "PARAMETERS", "REVISIONS", "SOURCE", "RECORD_ATTEMPT_NUMBER", "THROTTLING_ATTRIBUTE", "REPORT_SET"});
    }

    public void addReports(Collection<Report> reports) {
        this.reportSet.addAll(reports);
    }

    public Values toStormTuple() {
        return new Values(new Object[]{this.taskId, this.taskName, this.fileUrl, this.fileData, this.parameters, this.revisionToBeApplied, this.sourceDetails, this.recordAttemptNumber, this.throttlingGroupingAttribute, this.reportSet});
    }

    public boolean isMarkedAsDeleted() {
        return "true".equals(this.parameters.get("DELETED_RECORD"));
    }

    public void setMarkedAsDeleted(boolean markedAsDeleted) {
        if (markedAsDeleted) {
            this.parameters.put("DELETED_RECORD", "true");
        } else {
            this.parameters.remove("DELETED_RECORD");
        }
    }

    public void setThrottlingGroupingAttribute(String throttlingGroupingAttribute) {
        this.throttlingGroupingAttribute = throttlingGroupingAttribute;
    }

    public int readParallelizationParam() {
        return Optional.ofNullable(this.getParameter("MAXIMUM_PARALLELIZATION")).map(Integer::parseInt).orElse(Integer.MAX_VALUE);
    }

    public Date getHarvestDate() throws DateTimeParseException {
        return Date.from(DateHelper.parse((String)this.getParameter("HARVEST_DATE")));
    }

    public static StormTaskTupleBuilder builder() {
        return new StormTaskTupleBuilder();
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setRevisionToBeApplied(Revision revisionToBeApplied) {
        this.revisionToBeApplied = revisionToBeApplied;
    }

    public void setSourceDetails(OAIPMHHarvestingDetails sourceDetails) {
        this.sourceDetails = sourceDetails;
    }

    public void setRecordAttemptNumber(int recordAttemptNumber) {
        this.recordAttemptNumber = recordAttemptNumber;
    }

    public void setReportSet(Set<Report> reportSet) {
        this.reportSet = reportSet;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Revision getRevisionToBeApplied() {
        return this.revisionToBeApplied;
    }

    public OAIPMHHarvestingDetails getSourceDetails() {
        return this.sourceDetails;
    }

    public int getRecordAttemptNumber() {
        return this.recordAttemptNumber;
    }

    public Set<Report> getReportSet() {
        return this.reportSet;
    }

    public String getThrottlingGroupingAttribute() {
        return this.throttlingGroupingAttribute;
    }

    public static class StormTaskTupleBuilder {
        private long taskId;
        private String taskName;
        private String fileUrl;
        private byte[] fileData;
        private Map<String, String> parameters;
        private Revision revisionToBeApplied;
        private OAIPMHHarvestingDetails sourceDetails;
        private int recordAttemptNumber;
        private Set<Report> reportSet;
        private String throttlingGroupingAttribute;

        StormTaskTupleBuilder() {
        }

        public StormTaskTupleBuilder taskId(long taskId) {
            this.taskId = taskId;
            return this;
        }

        public StormTaskTupleBuilder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public StormTaskTupleBuilder fileUrl(String fileUrl) {
            this.fileUrl = fileUrl;
            return this;
        }

        public StormTaskTupleBuilder fileData(byte[] fileData) {
            this.fileData = fileData;
            return this;
        }

        public StormTaskTupleBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public StormTaskTupleBuilder revisionToBeApplied(Revision revisionToBeApplied) {
            this.revisionToBeApplied = revisionToBeApplied;
            return this;
        }

        public StormTaskTupleBuilder sourceDetails(OAIPMHHarvestingDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            return this;
        }

        public StormTaskTupleBuilder recordAttemptNumber(int recordAttemptNumber) {
            this.recordAttemptNumber = recordAttemptNumber;
            return this;
        }

        public StormTaskTupleBuilder reportSet(Set<Report> reportSet) {
            this.reportSet = reportSet;
            return this;
        }

        public StormTaskTupleBuilder throttlingGroupingAttribute(String throttlingGroupingAttribute) {
            this.throttlingGroupingAttribute = throttlingGroupingAttribute;
            return this;
        }

        public StormTaskTuple build() {
            return new StormTaskTuple(this.taskId, this.taskName, this.fileUrl, this.fileData, this.parameters, this.revisionToBeApplied, this.sourceDetails, this.recordAttemptNumber, this.reportSet, this.throttlingGroupingAttribute);
        }

        public String toString() {
            return "StormTaskTuple.StormTaskTupleBuilder(taskId=" + this.taskId + ", taskName=" + this.taskName + ", fileUrl=" + this.fileUrl + ", fileData=" + Arrays.toString(this.fileData) + ", parameters=" + String.valueOf(this.parameters) + ", revisionToBeApplied=" + String.valueOf(this.revisionToBeApplied) + ", sourceDetails=" + String.valueOf(this.sourceDetails) + ", recordAttemptNumber=" + this.recordAttemptNumber + ", reportSet=" + String.valueOf(this.reportSet) + ", throttlingGroupingAttribute=" + this.throttlingGroupingAttribute + ")";
        }
    }
}

