/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.utils.StormTaskTupleHelper;
import eu.europeana.enrichment.rest.client.report.Report;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class NotificationTuple {
    public static final String TASK_ID_FIELD_NAME = "TASK_ID";
    public static final String PARAMETERS_FIELD_NAME = "PARAMETERS";
    public static final String REPORT_SET_FIELD_NAME = "REPORT_SET";
    private final long taskId;
    private final Map<String, Object> parameters;
    private final Set<Report> reportSet = new HashSet<Report>();

    public NotificationTuple(long taskId, Map<String, Object> parameters) {
        this.taskId = taskId;
        this.parameters = parameters;
    }

    public NotificationTuple(long taskId, Map<String, Object> parameters, Set<Report> reports) {
        this(taskId, parameters);
        this.reportSet.addAll(reports);
    }

    public static NotificationTuple fromStormTuple(Tuple tuple) {
        return new NotificationTuple(tuple.getLongByField(TASK_ID_FIELD_NAME), (Map)tuple.getValueByField(PARAMETERS_FIELD_NAME), (Set)tuple.getValueByField(REPORT_SET_FIELD_NAME));
    }

    public static NotificationTuple prepareNotification(StormTaskTuple stormTaskTuple, RecordState state, String message, String additionalInformation) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("RESOURCE", stormTaskTuple.getFileUrl());
        parameters.put("STATE", state.toString());
        parameters.put("INFO_TEXT", message);
        parameters.put("STATE_DESCRIPTION", additionalInformation);
        parameters.put("START_TIME", StormTaskTupleHelper.getRecordProcessingStartTime(stormTaskTuple));
        if (stormTaskTuple.isMarkedAsDeleted()) {
            parameters.put("DELETED_RECORD", "true");
        }
        return new NotificationTuple(stormTaskTuple.getTaskId(), parameters, stormTaskTuple.getReportSet());
    }

    public static NotificationTuple prepareNotificationWithResultResource(StormTaskTuple stormTaskTuple, RecordState state, String message, String additionalInformation) {
        NotificationTuple nt = NotificationTuple.prepareNotification(stormTaskTuple, state, message, additionalInformation);
        nt.addParameter("RESULT_RESOURCE", stormTaskTuple.getParameter("OUTPUT_URL"));
        return nt;
    }

    public static NotificationTuple prepareNotificationWithResultResourceAndErrorMessage(StormTaskTuple stormTaskTuple, RecordState state, String message, String additionalInformation, String unifiedErrorMessage, String detailedErrorMessage) {
        NotificationTuple nt = NotificationTuple.prepareNotificationWithResultResource(stormTaskTuple, state, message, additionalInformation);
        nt.addParameter("UNIFIED_ERROR_MESSAGE", unifiedErrorMessage);
        nt.addParameter("EXCEPTION_ERROR_MESSAGE", detailedErrorMessage);
        return nt;
    }

    public static NotificationTuple prepareIndexingNotification(StormTaskTuple stormTaskTuple, RecordState state, String message, String additionalInformation) {
        NotificationTuple nt = NotificationTuple.prepareNotification(stormTaskTuple, state, message, additionalInformation);
        nt.addParameter("EUROPEANA_ID", stormTaskTuple.getParameter("EUROPEANA_ID"));
        return nt;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public static Fields getFields() {
        return new Fields(new String[]{TASK_ID_FIELD_NAME, PARAMETERS_FIELD_NAME, REPORT_SET_FIELD_NAME});
    }

    public Set<Report> getReportSet() {
        return this.reportSet;
    }

    public void addReports(Collection<Report> reports) {
        this.reportSet.addAll(reports);
    }

    public Values toStormTuple() {
        return new Values(new Object[]{this.taskId, this.parameters, this.reportSet});
    }

    public boolean isMarkedAsDeleted() {
        return "true".equals(this.parameters.get("DELETED_RECORD"));
    }

    public boolean isIgnoredRecord() {
        return "true".equals(this.parameters.get("IGNORED_RECORD"));
    }

    public String getResource() {
        return String.valueOf(this.parameters.get("RESOURCE"));
    }
}

