/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import java.util.Map;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologySubmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologySubmitter.class);
    public static final String START_TOPOLOGY_ON_LOCAL_CLUSTER_PROPERTY = "startTopologyOnLocalCluster";
    private static final boolean START_ON_LOCAL_CLUSTER = Boolean.getBoolean("startTopologyOnLocalCluster");

    private TopologySubmitter() {
    }

    public static void submitTopology(String name, Map stormConf, StormTopology topology) throws Exception {
        if (START_ON_LOCAL_CLUSTER) {
            LOGGER.warn("Cause \"{}\" property is set true, topology is started in LocalCluster!!!\nThis could be use for tests only!!!\n", (Object)START_TOPOLOGY_ON_LOCAL_CLUSTER_PROPERTY);
            LocalCluster lc = new LocalCluster();
            lc.submitTopology(name, stormConf, topology);
        } else {
            StormSubmitter.submitTopology((String)name, (Map)stormConf, (StormTopology)topology);
        }
    }
}

