/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import eu.europeana.cloud.service.dps.storm.utils.TopologyPropertiesException;
import java.util.Properties;

public class TopologyPropertiesValidator {
    private static final String ERROR_MESSAGE = "Missing topology property: ";

    private TopologyPropertiesValidator() {
    }

    public static void validateFor(String topologyName, Properties properties) {
        switch (topologyName) {
            case "xslt_topology": {
                TopologyPropertiesValidator.validateForXsltTopology(properties);
                break;
            }
            case "oai_topology": {
                TopologyPropertiesValidator.validateForOaiTopology(properties);
                break;
            }
            case "indexing_topology": {
                TopologyPropertiesValidator.validateIndexingTopology(properties);
                break;
            }
            default: {
                throw new TopologyPropertiesException("Validator not found for given topology name: " + topologyName);
            }
        }
    }

    private static void validateForXsltTopology(Properties properties) {
        TopologyPropertiesValidator.validateCommonProps(properties);
    }

    private static void validateForOaiTopology(Properties properties) {
        TopologyPropertiesValidator.validateCommonProps(properties);
    }

    private static void validateIndexingTopology(Properties properties) {
        TopologyPropertiesValidator.validateCommonProps(properties);
    }

    private static void validateCommonProps(Properties properties) {
        if (properties.getProperty("TOPOLOGY_NAME") == null) {
            throw new TopologyPropertiesException("Missing topology property: TOPOLOGY_NAME");
        }
        if (properties.getProperty("MESSAGE_TIMEOUT_IN_SECONDS") == null) {
            throw new TopologyPropertiesException("Missing topology property: MESSAGE_TIMEOUT_IN_SECONDS");
        }
    }
}

