/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.spout;

import eu.europeana.cloud.service.dps.DpsRecord;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.spout.ECloudSpout;
import eu.europeana.cloud.service.dps.storm.throttling.ThrottlingTupleGroupSelector;
import java.util.Map;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;

public class MediaSpout
extends ECloudSpout {
    private transient ThrottlingTupleGroupSelector generator;
    private final String defaultMaximumParallelization;

    public MediaSpout(String topologyName, String topic, KafkaSpoutConfig<String, DpsRecord> kafkaSpoutConfig, String hosts, int port, String keyspaceName, String userName, String password, String defaultMaximumParallelization) {
        super(topologyName, topic, kafkaSpoutConfig, hosts, port, keyspaceName, userName, password);
        this.defaultMaximumParallelization = defaultMaximumParallelization;
    }

    @Override
    protected void performThrottling(StormTaskTuple tuple) {
        this.applyDefaultMaximumParallelizationIfNotSet(tuple);
        int parallelizationParam = tuple.readParallelizationParam();
        this.maxTaskPending = parallelizationParam == 1 ? 1L : (long)parallelizationParam * 2L;
        tuple.setThrottlingGroupingAttribute(this.generator.generateForEdmObjectProcessingBolt(tuple));
    }

    private void applyDefaultMaximumParallelizationIfNotSet(StormTaskTuple tuple) {
        if (tuple.getParameter("MAXIMUM_PARALLELIZATION") == null) {
            tuple.addParameter("MAXIMUM_PARALLELIZATION", this.defaultMaximumParallelization);
        }
    }

    @Override
    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        super.open(conf, context, collector);
        this.generator = new ThrottlingTupleGroupSelector();
    }
}

