/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.service;

import eu.europeana.cloud.service.dps.storm.dao.HarvestedRecordsDAO;
import eu.europeana.cloud.service.dps.storm.incremental.CategorizationParameters;
import eu.europeana.cloud.service.dps.storm.incremental.CategorizationResult;
import eu.europeana.cloud.service.dps.storm.utils.HarvestedRecord;
import java.util.Date;
import java.util.Optional;

public abstract class HarvestedRecordCategorizationService {
    private final HarvestedRecordsDAO harvestedRecordsDAO;

    protected HarvestedRecordCategorizationService(HarvestedRecordsDAO harvestedRecordsDAO) {
        this.harvestedRecordsDAO = harvestedRecordsDAO;
    }

    public CategorizationResult categorize(CategorizationParameters categorizationParameters) {
        Optional<HarvestedRecord> harvestedRecord = this.readRecordFromDB(categorizationParameters);
        if (harvestedRecord.isEmpty()) {
            HarvestedRecord newHarvestedRecord = this.prepareHarvestedRecordDefinition(categorizationParameters);
            this.addRecordDefinitionToDB(newHarvestedRecord);
            return this.categorizeRecordAsReadyForProcessing(categorizationParameters, null);
        }
        this.updateRecordLatestHarvestDateAndMd5(harvestedRecord.get(), categorizationParameters);
        if (this.isRecordEligibleForProcessing(harvestedRecord.get(), categorizationParameters)) {
            return this.categorizeRecordAsReadyForProcessing(categorizationParameters, harvestedRecord.get());
        }
        return this.categorizeRecordAsNotReadyForProcessing(categorizationParameters, harvestedRecord.get());
    }

    protected abstract boolean isRecordEligibleForProcessing(HarvestedRecord var1, CategorizationParameters var2);

    private Optional<HarvestedRecord> readRecordFromDB(CategorizationParameters categorizationParameters) {
        return this.harvestedRecordsDAO.findRecord(categorizationParameters.getDatasetId(), categorizationParameters.getRecordId());
    }

    private HarvestedRecord prepareHarvestedRecordDefinition(CategorizationParameters categorizationParameters) {
        return HarvestedRecord.builder().metisDatasetId(categorizationParameters.getDatasetId()).recordLocalId(categorizationParameters.getRecordId()).latestHarvestDate(Date.from(categorizationParameters.getCurrentHarvestDate())).latestHarvestMd5(categorizationParameters.getRecordMd5()).build();
    }

    private void addRecordDefinitionToDB(HarvestedRecord harvestedRecord) {
        this.harvestedRecordsDAO.insertHarvestedRecord(harvestedRecord);
    }

    private void updateRecordLatestHarvestDateAndMd5(HarvestedRecord harvestedRecord, CategorizationParameters categorizationParameters) {
        this.harvestedRecordsDAO.updateLatestHarvestDateAndMd5(harvestedRecord.getMetisDatasetId(), harvestedRecord.getRecordLocalId(), Date.from(categorizationParameters.getCurrentHarvestDate()), categorizationParameters.getRecordMd5());
    }

    private CategorizationResult categorizeRecordAsReadyForProcessing(CategorizationParameters categorizationParameters, HarvestedRecord harvestedRecord) {
        return CategorizationResult.builder().category(CategorizationResult.Category.ELIGIBLE_FOR_PROCESSING).categorizationParameters(categorizationParameters).harvestedRecord(harvestedRecord).build();
    }

    private CategorizationResult categorizeRecordAsNotReadyForProcessing(CategorizationParameters categorizationParameters, HarvestedRecord harvestedRecord) {
        return CategorizationResult.builder().category(CategorizationResult.Category.ALREADY_PROCESSED).categorizationParameters(categorizationParameters).harvestedRecord(harvestedRecord).build();
    }
}

