/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.notification;

import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.storm.ErrorType;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskErrorsDAO;
import eu.europeana.cloud.service.dps.storm.dao.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.dao.NotificationsDAO;
import eu.europeana.cloud.service.dps.storm.notification.NotificationCacheEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationEntryCacheBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationEntryCacheBuilder.class);
    private final NotificationsDAO subTaskInfoDAO;
    private final CassandraTaskInfoDAO taskInfoDAO;
    private final CassandraTaskErrorsDAO taskErrorDAO;

    public NotificationEntryCacheBuilder(NotificationsDAO subTaskInfoDAO, CassandraTaskInfoDAO taskInfoDAO, CassandraTaskErrorsDAO taskErrorDAO) {
        this.subTaskInfoDAO = subTaskInfoDAO;
        this.taskInfoDAO = taskInfoDAO;
        this.taskErrorDAO = taskErrorDAO;
    }

    public NotificationCacheEntry build(long taskId) {
        TaskInfo taskInfo = this.taskInfoDAO.findById(taskId).orElseThrow();
        int processed = taskInfo.getProcessedRecordsCount() + taskInfo.getIgnoredRecordsCount() + taskInfo.getDeletedRecordsCount();
        NotificationCacheEntry.NotificationCacheEntryBuilder builder = NotificationCacheEntry.builder();
        builder.processed(processed);
        builder.errorTypes(new HashMap<String, ErrorType>());
        builder.expectedRecordsNumber(this.evaluateCredibleExpectedRecordNumber(taskInfo));
        if (processed > 0) {
            builder.processedRecordsCount(taskInfo.getProcessedRecordsCount());
            builder.ignoredRecordsCount(taskInfo.getIgnoredRecordsCount());
            builder.deletedRecordsCount(taskInfo.getDeletedRecordsCount());
            builder.processedErrorsCount(taskInfo.getProcessedErrorsCount());
            builder.deletedErrorsCount(taskInfo.getDeletedErrorsCount());
            builder.errorTypes(this.getMessagesUUIDsMap(taskId));
        }
        NotificationCacheEntry result = builder.build();
        LOGGER.info("Updated state of NotificationBolt from Cassandra for taskId={} counters={}", (Object)taskId, (Object)result);
        return result;
    }

    private int evaluateCredibleExpectedRecordNumber(TaskInfo taskInfo) {
        return taskInfo.getState() == TaskState.QUEUED ? taskInfo.getExpectedRecordsNumber() : -1;
    }

    private Map<String, ErrorType> getMessagesUUIDsMap(long taskId) {
        HashMap<String, ErrorType> errorMessageToUuidMap = new HashMap<String, ErrorType>();
        Iterator<ErrorType> it = this.taskErrorDAO.getAll(taskId);
        while (it.hasNext()) {
            ErrorType errorType = it.next();
            Optional<String> message = this.taskErrorDAO.getErrorMessage(taskId, errorType.getUuid());
            message.ifPresent(s -> errorMessageToUuidMap.put((String)s, ErrorType.builder().taskId(taskId).uuid(errorType.getUuid()).message((String)s).count(errorType.getCount()).build()));
        }
        return errorMessageToUuidMap;
    }
}

