/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.notification;

import com.eaio.uuid.UUID;
import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.service.dps.storm.ErrorType;
import eu.europeana.cloud.service.dps.storm.NotificationTuple;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationCacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationCacheEntry.class);
    private int processed;
    private int processedRecordsCount;
    private int ignoredRecordsCount;
    private int deletedRecordsCount;
    private int processedErrorsCount;
    private int deletedErrorsCount;
    private int expectedRecordsNumber;
    Map<String, ErrorType> errorTypes;

    public void incrementCounters(NotificationTuple notificationTuple) {
        ++this.processed;
        if (notificationTuple.isMarkedAsDeleted()) {
            ++this.deletedRecordsCount;
            if (this.isErrorTuple(notificationTuple)) {
                ++this.deletedErrorsCount;
            }
        } else if (notificationTuple.isIgnoredRecord()) {
            if (this.isErrorTuple(notificationTuple)) {
                LOGGER.error("Tuple is marked as ignored and error in the same time! It should not occur. Tuple: {}", (Object)notificationTuple);
                ++this.processedRecordsCount;
                ++this.processedErrorsCount;
            } else {
                ++this.ignoredRecordsCount;
            }
        } else {
            ++this.processedRecordsCount;
            if (this.isErrorTuple(notificationTuple)) {
                ++this.processedErrorsCount;
            }
        }
    }

    private boolean isErrorTuple(NotificationTuple notificationTuple) {
        return String.valueOf(notificationTuple.getParameters().get("STATE")).equalsIgnoreCase(RecordState.ERROR.toString());
    }

    public ErrorType getErrorType(String infoText) {
        return this.errorTypes.computeIfAbsent(infoText, key -> ErrorType.builder().uuid(new UUID().toString()).build());
    }

    NotificationCacheEntry(int processed, int processedRecordsCount, int ignoredRecordsCount, int deletedRecordsCount, int processedErrorsCount, int deletedErrorsCount, int expectedRecordsNumber, Map<String, ErrorType> errorTypes) {
        this.processed = processed;
        this.processedRecordsCount = processedRecordsCount;
        this.ignoredRecordsCount = ignoredRecordsCount;
        this.deletedRecordsCount = deletedRecordsCount;
        this.processedErrorsCount = processedErrorsCount;
        this.deletedErrorsCount = deletedErrorsCount;
        this.expectedRecordsNumber = expectedRecordsNumber;
        this.errorTypes = errorTypes;
    }

    public static NotificationCacheEntryBuilder builder() {
        return new NotificationCacheEntryBuilder();
    }

    public int getProcessed() {
        return this.processed;
    }

    public int getProcessedRecordsCount() {
        return this.processedRecordsCount;
    }

    public int getIgnoredRecordsCount() {
        return this.ignoredRecordsCount;
    }

    public int getDeletedRecordsCount() {
        return this.deletedRecordsCount;
    }

    public int getProcessedErrorsCount() {
        return this.processedErrorsCount;
    }

    public int getDeletedErrorsCount() {
        return this.deletedErrorsCount;
    }

    public int getExpectedRecordsNumber() {
        return this.expectedRecordsNumber;
    }

    public Map<String, ErrorType> getErrorTypes() {
        return this.errorTypes;
    }

    public String toString() {
        return "NotificationCacheEntry(processed=" + this.getProcessed() + ", processedRecordsCount=" + this.getProcessedRecordsCount() + ", ignoredRecordsCount=" + this.getIgnoredRecordsCount() + ", deletedRecordsCount=" + this.getDeletedRecordsCount() + ", processedErrorsCount=" + this.getProcessedErrorsCount() + ", deletedErrorsCount=" + this.getDeletedErrorsCount() + ", expectedRecordsNumber=" + this.getExpectedRecordsNumber() + ", errorTypes=" + this.getErrorTypes() + ")";
    }

    public static class NotificationCacheEntryBuilder {
        private int processed;
        private int processedRecordsCount;
        private int ignoredRecordsCount;
        private int deletedRecordsCount;
        private int processedErrorsCount;
        private int deletedErrorsCount;
        private int expectedRecordsNumber;
        private Map<String, ErrorType> errorTypes;

        NotificationCacheEntryBuilder() {
        }

        public NotificationCacheEntryBuilder processed(int processed) {
            this.processed = processed;
            return this;
        }

        public NotificationCacheEntryBuilder processedRecordsCount(int processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public NotificationCacheEntryBuilder ignoredRecordsCount(int ignoredRecordsCount) {
            this.ignoredRecordsCount = ignoredRecordsCount;
            return this;
        }

        public NotificationCacheEntryBuilder deletedRecordsCount(int deletedRecordsCount) {
            this.deletedRecordsCount = deletedRecordsCount;
            return this;
        }

        public NotificationCacheEntryBuilder processedErrorsCount(int processedErrorsCount) {
            this.processedErrorsCount = processedErrorsCount;
            return this;
        }

        public NotificationCacheEntryBuilder deletedErrorsCount(int deletedErrorsCount) {
            this.deletedErrorsCount = deletedErrorsCount;
            return this;
        }

        public NotificationCacheEntryBuilder expectedRecordsNumber(int expectedRecordsNumber) {
            this.expectedRecordsNumber = expectedRecordsNumber;
            return this;
        }

        public NotificationCacheEntryBuilder errorTypes(Map<String, ErrorType> errorTypes) {
            this.errorTypes = errorTypes;
            return this;
        }

        public NotificationCacheEntry build() {
            return new NotificationCacheEntry(this.processed, this.processedRecordsCount, this.ignoredRecordsCount, this.deletedRecordsCount, this.processedErrorsCount, this.deletedErrorsCount, this.expectedRecordsNumber, this.errorTypes);
        }

        public String toString() {
            return "NotificationCacheEntry.NotificationCacheEntryBuilder(processed=" + this.processed + ", processedRecordsCount=" + this.processedRecordsCount + ", ignoredRecordsCount=" + this.ignoredRecordsCount + ", deletedRecordsCount=" + this.deletedRecordsCount + ", processedErrorsCount=" + this.processedErrorsCount + ", deletedErrorsCount=" + this.deletedErrorsCount + ", expectedRecordsNumber=" + this.expectedRecordsNumber + ", errorTypes=" + this.errorTypes + ")";
        }
    }
}

