/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.TaskDiagnosticInfo;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;

@Retryable(maxAttempts=7)
public class TaskDiagnosticInfoDAO
extends CassandraDAO {
    private static TaskDiagnosticInfoDAO instance = null;
    private PreparedStatement findByIdStatement;
    private PreparedStatement updateRecordsRetryCount;
    private PreparedStatement updateStartedRecordsCount;
    private PreparedStatement updateStartOnStormTime;
    private PreparedStatement updateFinishOnStormTime;
    private PreparedStatement updatePostprocessingStartTime;
    private PreparedStatement updateLastRecordFinishedOnStormTime;
    private PreparedStatement updateQueuedTime;

    public TaskDiagnosticInfoDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public TaskDiagnosticInfoDAO() {
    }

    public static synchronized TaskDiagnosticInfoDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (TaskDiagnosticInfoDAO)RetryableMethodExecutor.createRetryProxy((Object)new TaskDiagnosticInfoDAO(cassandra));
        }
        return instance;
    }

    @Override
    protected void prepareStatements() {
        this.findByIdStatement = this.prepare(String.format("SELECT * FROM %s WHERE %s = ?", "task_diagnostic_info", "task_id"));
        this.updateStartedRecordsCount = this.prepareUpdateQuery("started_records_count");
        this.updateRecordsRetryCount = this.prepareUpdateQuery("records_retry_count");
        this.updateQueuedTime = this.prepareUpdateQuery("queued_time");
        this.updateStartOnStormTime = this.prepareUpdateQuery("start_on_storm_time");
        this.updateLastRecordFinishedOnStormTime = this.prepareUpdateQuery("last_record_finished_on_storm_time");
        this.updateFinishOnStormTime = this.prepareUpdateQuery("finish_on_storm_time");
        this.updatePostprocessingStartTime = this.prepareUpdateQuery("post_processing_start_time");
    }

    private PreparedStatement prepareUpdateQuery(String column) {
        return this.prepare(String.format("INSERT INTO %s(%s,%s) VALUES(?,?)", "task_diagnostic_info", "task_id", column));
    }

    public Optional<TaskDiagnosticInfo> findById(long taskId) throws NoHostAvailableException, QueryExecutionException {
        return Optional.ofNullable(this.dbService.getSession().execute((Statement)this.findByIdStatement.bind(new Object[]{taskId})).one()).map(this::createTaskInfo);
    }

    public void updateRecordsRetryCount(long taskId, int retryCount) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateRecordsRetryCount.bind(new Object[]{taskId, retryCount}));
    }

    public void updateStartedRecordsCount(long taskId, int startedCount) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateStartedRecordsCount.bind(new Object[]{taskId, startedCount}));
    }

    public void updateQueuedTime(long taskId, Instant time) {
        this.dbService.getSession().execute((Statement)this.updateQueuedTime.bind(new Object[]{taskId, Date.from(time)}));
    }

    public void updateStartOnStormTime(long taskId, Instant time) {
        this.dbService.getSession().execute((Statement)this.updateStartOnStormTime.bind(new Object[]{taskId, Date.from(time)}));
    }

    public void updateFinishOnStormTime(long taskId, Instant time) {
        this.dbService.getSession().execute((Statement)this.updateFinishOnStormTime.bind(new Object[]{taskId, Date.from(time)}));
    }

    public void updatePostprocessingStartTime(long taskId, Instant time) {
        this.dbService.getSession().execute((Statement)this.updatePostprocessingStartTime.bind(new Object[]{taskId, Date.from(time)}));
    }

    public BoundStatement updateLastRecordFinishedOnStormTimeStatement(long taskId, Instant time) {
        return this.updateLastRecordFinishedOnStormTime.bind(new Object[]{taskId, Date.from(time)});
    }

    public void updateLastRecordFinishedOnStormTime(long taskId, Instant time) {
        this.dbService.getSession().execute((Statement)this.updateLastRecordFinishedOnStormTimeStatement(taskId, time));
    }

    private TaskDiagnosticInfo createTaskInfo(Row row) {
        return TaskDiagnosticInfo.builder().taskId(row.getLong("task_id")).startedRecordsCount(row.getInt("started_records_count")).recordsRetryCount(row.getInt("records_retry_count")).queuedTime(this.getInstant(row, "queued_time")).startOnStormTime(this.getInstant(row, "start_on_storm_time")).finishOnStormTime(this.getInstant(row, "finish_on_storm_time")).postProcessingStartTime(this.getInstant(row, "post_processing_start_time")).lastRecordFinishedOnStormTime(this.getInstant(row, "last_record_finished_on_storm_time")).build();
    }

    private Instant getInstant(Row row, String column) {
        return Optional.ofNullable(row.getTimestamp(column)).map(Date::toInstant).orElse(null);
    }
}

