/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.gson.Gson;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;

@Retryable(maxAttempts=7)
public class StatisticsReportDAO
extends CassandraDAO {
    private static StatisticsReportDAO instance = null;
    private final Gson gson = new Gson();
    private PreparedStatement getStatisticsReportStatement;
    private PreparedStatement removeStatisticsReportStatement;
    private PreparedStatement storeStatisticsReportStatement;
    private PreparedStatement checkStatisticsReportStatement;

    public StatisticsReportDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public StatisticsReportDAO() {
    }

    public static synchronized StatisticsReportDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (StatisticsReportDAO)RetryableMethodExecutor.createRetryProxy((Object)new StatisticsReportDAO(cassandra));
        }
        return instance;
    }

    @Override
    protected void prepareStatements() {
        this.storeStatisticsReportStatement = this.dbService.getSession().prepare("INSERT INTO statistics_reports (task_id,report_data) VALUES (?,textasblob(?))");
        this.checkStatisticsReportStatement = this.dbService.getSession().prepare("SELECT task_id FROM statistics_reports WHERE task_id = ?");
        this.getStatisticsReportStatement = this.dbService.getSession().prepare("SELECT blobastext(report_data) FROM statistics_reports WHERE task_id = ?");
        this.removeStatisticsReportStatement = this.dbService.getSession().prepare("DELETE  FROM statistics_reports WHERE task_id = ?");
    }

    public void storeReport(long taskId, StatisticsReport report) {
        String reportSerialized = this.gson.toJson((Object)report);
        if (reportSerialized != null) {
            BoundStatement bs = this.storeStatisticsReportStatement.bind(new Object[]{taskId, reportSerialized});
            this.dbService.getSession().execute((Statement)bs);
        }
    }

    public boolean isReportStored(long taskId) {
        BoundStatement bs = this.checkStatisticsReportStatement.bind(new Object[]{taskId});
        ResultSet rs = this.dbService.getSession().execute((Statement)bs);
        return rs.iterator().hasNext();
    }

    public StatisticsReport getStatisticsReport(long taskId) {
        BoundStatement bs = this.getStatisticsReportStatement.bind(new Object[]{taskId});
        ResultSet rs = this.dbService.getSession().execute((Statement)bs);
        if (rs.iterator().hasNext()) {
            Row row = rs.one();
            String report = row.getString(0);
            return (StatisticsReport)this.gson.fromJson(report, StatisticsReport.class);
        }
        return null;
    }

    public void removeStatisticsReport(long taskId) {
        this.dbService.getSession().execute((Statement)this.removeStatisticsReportStatement.bind(new Object[]{taskId}));
    }
}

