/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.Notification;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.conversion.NotificationConverter;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Retryable(maxAttempts=7)
public class NotificationsDAO
extends CassandraDAO {
    private static NotificationsDAO instance = null;
    public static final int BUCKET_SIZE = 10000;
    public static final String STATE_DESCRIPTION_KEY = "stateDescription";
    public static final String PROCESSING_TIME_KEY = "processingTime";
    public static final String EUROPEANA_ID_KEY = "europeanaId";
    private PreparedStatement subtaskInsertStatement;
    private PreparedStatement processedFilesCountStatement;
    private PreparedStatement removeNotificationsByTaskId;
    private PreparedStatement selectNotificationFromGivenBucketAndInGivenResourceNumRange;

    public NotificationsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public NotificationsDAO() {
    }

    public static synchronized NotificationsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (NotificationsDAO)RetryableMethodExecutor.createRetryProxy((Object)new NotificationsDAO(cassandra));
        }
        return instance;
    }

    public List<Notification> getNotificationsFromGivenBucketAndWithinGivenResourceNumRange(long taskId, int from, int to, int i) {
        BoundStatement selectFromNotification = this.selectNotificationFromGivenBucketAndInGivenResourceNumRange.bind(new Object[]{taskId, i, from, to});
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        this.dbService.getSession().execute((Statement)selectFromNotification).forEach(row -> notifications.add(NotificationConverter.fromDBRow(row)));
        return notifications;
    }

    public void insert(int resourceNum, long taskId, String topologyName, String resource, String state, String infoTxt, Map<String, String> additionalInformation, String resultResource) {
        this.dbService.getSession().execute((Statement)this.subtaskInsertStatement.bind(new Object[]{taskId, NotificationsDAO.bucketNumber(resourceNum), resourceNum, topologyName, resource, state, infoTxt, additionalInformation, resultResource}));
    }

    public BoundStatement insertNotificationStatement(Notification notification) {
        return this.subtaskInsertStatement.bind(new Object[]{notification.getTaskId(), NotificationsDAO.bucketNumber(notification.getResourceNum()), notification.getResourceNum(), notification.getTopologyName(), notification.getResource(), notification.getState(), notification.getInfoText(), notification.getAdditionalInformation(), notification.getResultResource()});
    }

    public int getProcessedFilesCount(long taskId) {
        Row row;
        int bucketNumber = 0;
        int filesCount = 0;
        do {
            ResultSet rs;
            if ((row = (rs = this.dbService.getSession().execute((Statement)this.processedFilesCountStatement.bind(new Object[]{taskId, bucketNumber}))).one()) == null) continue;
            filesCount = row.getInt("resource_num");
            ++bucketNumber;
        } while (row != null);
        return filesCount;
    }

    public void removeNotifications(long taskId) {
        int lastBucket;
        for (int i = lastBucket = NotificationsDAO.bucketNumber(this.getProcessedFilesCount(taskId) - 1); i >= 0; --i) {
            this.dbService.getSession().execute((Statement)this.removeNotificationsByTaskId.bind(new Object[]{taskId, i}));
        }
    }

    public static int bucketNumber(int resourceNum) {
        return resourceNum / 10000;
    }

    @Override
    protected void prepareStatements() {
        this.subtaskInsertStatement = this.dbService.getSession().prepare(String.format("insert into %s(%s, %s, %s, %s, %s, %s, %s, %s, %s) values (?,?,?,?,?,?,?,?,?)", "notifications", "task_id", "bucket_number", "resource_num", "topology_name", "resource", "state", "info_text", "additional_information", "result_resource"));
        this.subtaskInsertStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.processedFilesCountStatement = this.dbService.getSession().prepare(String.format("select %s from %s where %s = ? and %s = ? order by %s desc limit 1", "resource_num", "notifications", "task_id", "bucket_number", "resource_num"));
        this.processedFilesCountStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeNotificationsByTaskId = this.dbService.getSession().prepare(String.format("delete from %s where %s = ? and %s = ?", "notifications", "task_id", "bucket_number"));
        this.selectNotificationFromGivenBucketAndInGivenResourceNumRange = this.dbService.getSession().prepare("SELECT *FROM notifications WHERE task_id = ? AND bucket_number = ? AND resource_num >= ? AND resource_num <= ?");
    }
}

