/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.metis.indexing.TargetIndexingDatabase;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import eu.europeana.cloud.service.dps.storm.utils.BucketRecordIterator;
import eu.europeana.cloud.service.dps.storm.utils.BucketUtils;
import eu.europeana.cloud.service.dps.storm.utils.HarvestedRecord;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;

public class HarvestedRecordsDAO
extends CassandraDAO {
    private static final int MAX_NUMBER_OF_BUCKETS = 64;
    private static final String DB_COMMUNICATION_FAILURE_MESSAGE = "Database communication failure";
    private static HarvestedRecordsDAO instance;
    private PreparedStatement insertHarvestedRecordStatement;
    private PreparedStatement updateLatestHarvestDateAndMd5Statement;
    private PreparedStatement updatePublishedHarvestDateStatement;
    private PreparedStatement findRecordStatement;
    private PreparedStatement findAllRecordInDatasetStatement;
    private PreparedStatement deleteRecordStatement;
    private PreparedStatement updatePreviewColumnsForExistingStatement;
    private PreparedStatement updatePublishedColumnsForExistingStatement;

    public HarvestedRecordsDAO() {
    }

    public HarvestedRecordsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public static synchronized HarvestedRecordsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (HarvestedRecordsDAO)RetryableMethodExecutor.createRetryProxy((Object)new HarvestedRecordsDAO(cassandra));
        }
        return instance;
    }

    @Override
    protected void prepareStatements() {
        this.insertHarvestedRecordStatement = this.dbService.getSession().prepare("INSERT INTO harvested_records(metis_dataset_id,bucket_number,record_local_id,latest_harvest_date,latest_harvest_md5,preview_harvest_date,preview_harvest_md5,published_harvest_date,published_harvest_md5) VALUES(?,?,?,?,?,?,?,?,?);");
        this.updateLatestHarvestDateAndMd5Statement = this.dbService.getSession().prepare("UPDATE harvested_records SET latest_harvest_date = ? ,latest_harvest_md5 = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.updatePreviewColumnsForExistingStatement = this.dbService.getSession().prepare("UPDATE harvested_records SET preview_harvest_date = ? ,preview_harvest_md5 = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ?  IF EXISTS");
        this.updatePublishedColumnsForExistingStatement = this.dbService.getSession().prepare("UPDATE harvested_records SET published_harvest_date = ? ,published_harvest_md5 = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ?  IF EXISTS");
        this.updatePublishedHarvestDateStatement = this.dbService.getSession().prepare("UPDATE harvested_records SET published_harvest_date = ?  WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.findRecordStatement = this.dbService.getSession().prepare("SELECT * FROM harvested_records WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
        this.findAllRecordInDatasetStatement = this.dbService.getSession().prepare("SELECT * FROM harvested_records WHERE metis_dataset_id = ?  AND bucket_number = ? ");
        this.deleteRecordStatement = this.dbService.getSession().prepare("DELETE FROM harvested_records WHERE metis_dataset_id = ?  AND bucket_number = ?  AND record_local_id = ? ");
    }

    @Retryable(maxAttempts=7)
    public void insertHarvestedRecord(HarvestedRecord harvestedRecord) {
        this.dbService.getSession().execute((Statement)this.prepareInsertStatement(harvestedRecord));
    }

    public BoundStatement prepareInsertStatement(HarvestedRecord harvestedRecord) {
        return this.insertHarvestedRecordStatement.bind(new Object[]{harvestedRecord.getMetisDatasetId(), this.bucketNoFor(harvestedRecord.getRecordLocalId()), harvestedRecord.getRecordLocalId(), harvestedRecord.getLatestHarvestDate(), harvestedRecord.getLatestHarvestMd5(), harvestedRecord.getPreviewHarvestDate(), harvestedRecord.getPreviewHarvestMd5(), harvestedRecord.getPublishedHarvestDate(), harvestedRecord.getPublishedHarvestMd5()});
    }

    @Retryable(maxAttempts=7)
    public void updateLatestHarvestDateAndMd5(String metisDatasetId, String recordId, Date harvestDate, UUID harvestMd5) {
        this.dbService.getSession().execute((Statement)this.updateLatestHarvestDateAndMd5Statement.bind(new Object[]{harvestDate, harvestMd5, metisDatasetId, this.bucketNoFor(recordId), recordId}));
    }

    @Retryable(maxAttempts=7)
    public void updatePublishedHarvestDate(String metisDatasetId, String recordId, Date indexingDate) {
        this.dbService.getSession().execute((Statement)this.updatePublishedHarvestDateStatement.bind(new Object[]{indexingDate, metisDatasetId, this.bucketNoFor(recordId), recordId}));
    }

    BoundStatement prepareCleanIndexedColumns(String metisDatasetId, String recordId, TargetIndexingDatabase targetDb) {
        switch (targetDb) {
            case PREVIEW: {
                return this.prepareCleanPreviewColumns(metisDatasetId, recordId);
            }
            case PUBLISH: {
                return this.prepareCleanPublishedColumns(metisDatasetId, recordId);
            }
        }
        throw new IllegalArgumentException("Unsupported TargetIndexingDatabase: " + targetDb);
    }

    private BoundStatement prepareCleanPreviewColumns(String metisDatasetId, String recordId) {
        return this.updatePreviewColumnsForExistingStatement.bind(new Object[]{null, null, metisDatasetId, this.bucketNoFor(recordId), recordId});
    }

    private BoundStatement prepareCleanPublishedColumns(String metisDatasetId, String recordId) {
        return this.updatePublishedColumnsForExistingStatement.bind(new Object[]{null, null, metisDatasetId, this.bucketNoFor(recordId), recordId});
    }

    @Retryable(maxAttempts=7)
    public void deleteRecord(String metisDatasetId, String recordId) {
        this.dbService.getSession().execute((Statement)this.deleteRecordStatement.bind(new Object[]{metisDatasetId, this.bucketNoFor(recordId), recordId}));
    }

    @Retryable(maxAttempts=7)
    public Optional<HarvestedRecord> findRecord(String metisDatasetId, String recordId) {
        return Optional.ofNullable(this.dbService.getSession().execute((Statement)this.findRecordStatement.bind(new Object[]{metisDatasetId, this.bucketNoFor(recordId), recordId})).one()).map(HarvestedRecord::from);
    }

    @Retryable(maxAttempts=7)
    public void executeBatch(BatchStatement batch) {
        this.dbService.getSession().execute((Statement)batch);
    }

    public Iterator<HarvestedRecord> findDatasetRecords(String metisDatasetId) {
        return new BucketRecordIterator<HarvestedRecord>(64, bucketNumber -> this.queryBucket(metisDatasetId, bucketNumber), HarvestedRecord::from);
    }

    private Iterator<Row> queryBucket(String metisDatasetId, Integer bucketNumber) {
        return (Iterator)RetryableMethodExecutor.execute((String)DB_COMMUNICATION_FAILURE_MESSAGE, (int)7, (int)10000, () -> this.dbService.getSession().execute((Statement)this.findAllRecordInDatasetStatement.bind(new Object[]{metisDatasetId, bucketNumber})).iterator());
    }

    int bucketNoFor(String recordId) {
        return BucketUtils.bucketNumber(recordId, 64);
    }
}

