/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Statement;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import eu.europeana.cloud.service.dps.metis.indexing.TargetIndexingDatabase;
import eu.europeana.cloud.service.dps.storm.dao.HarvestedRecordsDAO;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestedRecordsBatchCleaner
implements AutoCloseable {
    static final int BATCH_SIZE = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(HarvestedRecordsBatchCleaner.class);
    private final HarvestedRecordsDAO dao;
    private final String metisDatasetId;
    private final TargetIndexingDatabase targetDb;
    private final Multimap<Integer, String> recordIdsByBucketMap = ArrayListMultimap.create();
    private int cleanedCount;

    public HarvestedRecordsBatchCleaner(HarvestedRecordsDAO dao, String metisDatasetId, TargetIndexingDatabase targetDb) {
        this.dao = dao;
        this.metisDatasetId = metisDatasetId;
        this.targetDb = targetDb;
    }

    public void cleanRecord(String recordId) {
        int bucketNo = this.dao.bucketNoFor(recordId);
        this.recordIdsByBucketMap.put((Object)bucketNo, (Object)recordId);
        if (this.recordIdsByBucketMap.get((Object)bucketNo).size() >= 1000) {
            this.saveInBatch(this.recordIdsByBucketMap.removeAll((Object)bucketNo));
        }
    }

    @Override
    public void close() {
        Iterator iterator = this.recordIdsByBucketMap.keySet().iterator();
        while (iterator.hasNext()) {
            int bucketNo = (Integer)iterator.next();
            this.saveInBatch(this.recordIdsByBucketMap.get((Object)bucketNo));
        }
    }

    public int getCleanedCount() {
        return this.cleanedCount;
    }

    private void saveInBatch(Collection<String> recordIds) {
        BatchStatement batch = new BatchStatement(BatchStatement.Type.UNLOGGED);
        for (String recordId : recordIds) {
            batch.add((Statement)this.dao.prepareCleanIndexedColumns(this.metisDatasetId, recordId, this.targetDb));
        }
        this.dao.executeBatch(batch);
        this.cleanedCount += recordIds.size();
        LOGGER.info("Cleaned: {} date and MD5 of metisDatasetId: {}, for {} records.", new Object[]{this.targetDb, this.metisDatasetId, recordIds.size()});
    }
}

