/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.conversion.TaskInfoConverter;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import eu.europeana.cloud.service.dps.storm.utils.SubmitTaskParameters;
import java.util.Date;
import java.util.Optional;

@Retryable(maxAttempts=7)
public class CassandraTaskInfoDAO
extends CassandraDAO {
    private static CassandraTaskInfoDAO instance = null;
    private PreparedStatement taskSearchStatement;
    private PreparedStatement taskInsertStatement;
    private PreparedStatement updateCounters;
    private PreparedStatement finishTask;
    private PreparedStatement updateStatusExpectedSizeStatement;
    private PreparedStatement updateStateStatement;
    private PreparedStatement updateSubmitParameters;
    private PreparedStatement updatePostProcessedRecordsCount;
    private PreparedStatement updateExpectedPostProcessedRecordsNumber;

    public CassandraTaskInfoDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public CassandraTaskInfoDAO() {
    }

    public static synchronized CassandraTaskInfoDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (CassandraTaskInfoDAO)RetryableMethodExecutor.createRetryProxy((Object)new CassandraTaskInfoDAO(cassandra));
        }
        return instance;
    }

    @Override
    protected void prepareStatements() {
        this.taskSearchStatement = this.dbService.getSession().prepare("SELECT * FROM task_info WHERE task_id = ?");
        this.updateCounters = this.dbService.getSession().prepare("UPDATE task_info SET processed_records_count = ? , processed_errors_count = ?WHERE task_id = ?");
        this.updateCounters = this.dbService.getSession().prepare("UPDATE task_info SET processed_records_count = ? , ignored_records_count = ? , deleted_records_count = ? , processed_errors_count = ? , deleted_errors_count = ? WHERE task_id = ?");
        this.taskInsertStatement = this.dbService.getSession().prepare("INSERT INTO task_info(task_id,topology_name,state,state_description,sent_timestamp,start_timestamp,finish_timestamp,expected_records_number,processed_records_count,ignored_records_count,deleted_records_count,processed_errors_count,deleted_errors_count,expected_post_processed_records_number,post_processed_records_count,definition) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        this.finishTask = this.dbService.getSession().prepare("UPDATE task_info SET state = ? , state_description = ? , finish_timestamp = ?  WHERE task_id = ?");
        this.updateStatusExpectedSizeStatement = this.dbService.getSession().prepare("UPDATE task_info SET state = ? , expected_records_number = ?  WHERE task_id = ?");
        this.updateStateStatement = this.dbService.getSession().prepare("UPDATE task_info SET state = ? , state_description = ?  WHERE task_id = ? ");
        this.updateSubmitParameters = this.prepare("UPDATE task_info SET start_timestamp = ?, state = ? , state_description = ? , expected_records_number = ?  WHERE task_id = ?");
        this.updatePostProcessedRecordsCount = this.prepare("UPDATE task_info SET post_processed_records_count = ? WHERE task_id = ?");
        this.updateExpectedPostProcessedRecordsNumber = this.prepare("UPDATE task_info SET expected_post_processed_records_number = ? WHERE task_id = ?");
    }

    public Optional<TaskInfo> findById(long taskId) throws NoHostAvailableException, QueryExecutionException {
        return Optional.ofNullable(this.dbService.getSession().execute((Statement)this.taskSearchStatement.bind(new Object[]{taskId})).one()).map(TaskInfoConverter::fromDBRow);
    }

    @Retryable(maxAttempts=7, errorMessage="Error while inserting task")
    public void insert(TaskInfo taskInfo) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.taskInsertStatement.bind(new Object[]{taskInfo.getId(), taskInfo.getTopologyName(), String.valueOf(taskInfo.getState()), taskInfo.getStateDescription(), taskInfo.getSentTimestamp(), taskInfo.getStartTimestamp(), taskInfo.getFinishTimestamp(), taskInfo.getExpectedRecordsNumber(), taskInfo.getProcessedRecordsCount(), taskInfo.getIgnoredRecordsCount(), taskInfo.getDeletedRecordsCount(), taskInfo.getProcessedErrorsCount(), taskInfo.getDeletedErrorsCount(), taskInfo.getExpectedPostProcessedRecordsNumber(), taskInfo.getPostProcessedRecordsCount(), taskInfo.getDefinition()}));
    }

    public void setTaskCompletelyProcessed(long taskId, String info) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.finishTask.bind(new Object[]{TaskState.PROCESSED.toString(), info, new Date(), taskId}));
    }

    public void setTaskDropped(long taskId, String info) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.finishTask.bind(new Object[]{String.valueOf(TaskState.DROPPED), info, new Date(), taskId}));
    }

    public BoundStatement updateProcessedFilesStatement(long taskId, int processedRecordsCount, int ignoredRecordsCount, int deletedRecordsCount, int processedErrorsCount, int deletedErrorsCount) {
        return this.updateCounters.bind(new Object[]{processedRecordsCount, ignoredRecordsCount, deletedRecordsCount, processedErrorsCount, deletedErrorsCount, taskId});
    }

    public void setUpdateProcessedFiles(long taskId, int processedRecordsCount, int ignoredRecordsCount, int deletedRecordsCount, int processedErrorsCount, int deletedErrorsCount) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateProcessedFilesStatement(taskId, processedRecordsCount, ignoredRecordsCount, deletedRecordsCount, processedErrorsCount, deletedErrorsCount));
    }

    public void updatePostProcessedRecordsCount(long taskId, int postProcessedRecordsCount) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updatePostProcessedRecordsCount.bind(new Object[]{postProcessedRecordsCount, taskId}));
    }

    public void updateExpectedPostProcessedRecordsNumber(long taskId, int expectedPostProcessedRecordsNumber) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateExpectedPostProcessedRecordsNumber.bind(new Object[]{expectedPostProcessedRecordsNumber, taskId}));
    }

    public void updateStatusExpectedSize(long taskId, TaskState state, int expectedSize) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateStatusExpectedSizeStatement.bind(new Object[]{String.valueOf(state), expectedSize, taskId}));
    }

    public void updateState(long taskId, TaskState state, String info) {
        this.dbService.getSession().execute((Statement)this.updateStateStatement(taskId, state, info));
    }

    public BoundStatement updateStateStatement(long taskId, TaskState state, String info) {
        return this.updateStateStatement.bind(new Object[]{String.valueOf(state), info, taskId});
    }

    public boolean isDroppedTask(long taskId) throws TaskInfoDoesNotExistException {
        return this.findById(taskId).orElseThrow(TaskInfoDoesNotExistException::new).getState() == TaskState.DROPPED;
    }

    public void updateSubmitParameters(SubmitTaskParameters parameters) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateSubmitParameters.bind(new Object[]{parameters.getTaskInfo().getStartTimestamp(), String.valueOf(parameters.getTaskInfo().getState()), parameters.getTaskInfo().getStateDescription(), parameters.getTaskInfo().getExpectedRecordsNumber(), parameters.getTask().getTaskId()}));
    }
}

