/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.common.collect.Iterators;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.ErrorNotification;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.ErrorType;
import eu.europeana.cloud.service.dps.storm.conversion.ErrorNotificationConverter;
import eu.europeana.cloud.service.dps.storm.conversion.ErrorTypeConverter;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@Retryable(maxAttempts=7)
public class CassandraTaskErrorsDAO
extends CassandraDAO {
    private static CassandraTaskErrorsDAO instance = null;
    private PreparedStatement insertErrorStatement;
    private PreparedStatement insertErrorCounterStatement;
    private PreparedStatement selectErrorCountsForErrorTypeStatement;
    private PreparedStatement removeErrorCountsStatement;
    private PreparedStatement removeErrorNotifications;
    private PreparedStatement selectErrorTypeFieldFromErrorTypeStatement;
    private PreparedStatement selectErrorTypesStatement;
    private PreparedStatement selectErrorNotificationStatement;
    private PreparedStatement selectErrorNotificationsWithGivenLimitStatement;
    private PreparedStatement selectErrorTypeStatement;

    public CassandraTaskErrorsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public CassandraTaskErrorsDAO() {
    }

    public static synchronized CassandraTaskErrorsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (CassandraTaskErrorsDAO)RetryableMethodExecutor.createRetryProxy((Object)new CassandraTaskErrorsDAO(cassandra));
        }
        return instance;
    }

    public List<ErrorType> getErrorTypes(long taskId) {
        ArrayList<ErrorType> errorTypes = new ArrayList<ErrorType>();
        this.dbService.getSession().execute((Statement)this.selectErrorTypesStatement.bind(new Object[]{taskId})).forEach(row -> errorTypes.add(ErrorTypeConverter.fromDBRow(row)));
        return errorTypes;
    }

    public void insertErrorCounter(long taskId, String errorType, int number) {
        this.dbService.getSession().execute((Statement)this.insertErrorCounterStatement(taskId, ErrorType.builder().taskId(taskId).count(number).uuid(errorType).build()));
    }

    public BoundStatement insertErrorCounterStatement(long taskId, ErrorType errorType) {
        return this.insertErrorCounterStatement.bind(new Object[]{taskId, UUID.fromString(errorType.getUuid()), errorType.getCount()});
    }

    public void insertError(long taskId, String errorType, String errorMessage, String resource, String additionalInformations) {
        this.dbService.getSession().execute((Statement)this.insertErrorStatement(ErrorNotification.builder().taskId(taskId).errorType(errorType).errorMessage(errorMessage).resource(resource).additionalInformations(additionalInformations).build()));
    }

    public BoundStatement insertErrorStatement(ErrorNotification errorNotification) {
        return this.insertErrorStatement.bind(new Object[]{errorNotification.getTaskId(), UUID.fromString(errorNotification.getErrorType()), errorNotification.getErrorMessage(), errorNotification.getResource(), errorNotification.getAdditionalInformations()});
    }

    public Optional<ErrorType> getErrorType(long taskId, UUID errorTypeUUID) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.selectErrorTypeStatement.bind(new Object[]{taskId, errorTypeUUID}));
        return rs.iterator().hasNext() ? Optional.of(ErrorTypeConverter.fromDBRow(rs.one())) : Optional.empty();
    }

    public long selectErrorCountsForErrorType(long taskId, UUID errorType) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.selectErrorCountsForErrorTypeStatement.bind(new Object[]{taskId, errorType}));
        Row result = rs.one();
        if (result != null) {
            return result.getInt("error_count");
        }
        return 0L;
    }

    public Iterator<ErrorType> getAll(long taskId) {
        return Iterators.transform((Iterator)this.dbService.getSession().execute((Statement)this.selectErrorTypesStatement.bind(new Object[]{taskId})).iterator(), row -> ErrorType.builder().count(row.getInt("error_count")).uuid(row.getUUID("error_type").toString()).build());
    }

    public Optional<String> getErrorMessage(long taskId, String errorType) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.selectErrorNotificationStatement.bind(new Object[]{taskId, UUID.fromString(errorType)}));
        if (!rs.iterator().hasNext()) {
            return Optional.empty();
        }
        String message = rs.one().getString("error_message");
        return Optional.of(message);
    }

    public List<ErrorNotification> getErrorNotificationsWithGivenLimit(long taskId, UUID errorTypeUid, int idsCount) {
        ArrayList<ErrorNotification> errorNotifications = new ArrayList<ErrorNotification>();
        this.dbService.getSession().execute((Statement)this.selectErrorNotificationsWithGivenLimitStatement.bind(new Object[]{taskId, errorTypeUid, idsCount})).forEach(row -> errorNotifications.add(ErrorNotificationConverter.fromDBRow(row)));
        return errorNotifications;
    }

    public void removeErrors(long taskId) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.selectErrorTypeFieldFromErrorTypeStatement.bind(new Object[]{taskId}));
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            UUID errorType = row.getUUID("error_type");
            this.dbService.getSession().execute((Statement)this.removeErrorNotifications.bind(new Object[]{taskId, errorType}));
        }
        this.dbService.getSession().execute((Statement)this.removeErrorCountsStatement.bind(new Object[]{taskId}));
    }

    @Override
    protected void prepareStatements() {
        this.insertErrorStatement = this.dbService.getSession().prepare("INSERT INTO error_notifications(task_id,error_type,error_message,resource,additional_informations) VALUES (?,?,?,?,?)");
        this.insertErrorCounterStatement = this.dbService.getSession().prepare("INSERT INTO error_types(task_id,error_type,error_count) VALUES (?,?,?)");
        this.selectErrorCountsForErrorTypeStatement = this.dbService.getSession().prepare("SELECT error_count FROM error_types WHERE task_id = ? AND error_type = ?");
        this.selectErrorTypeFieldFromErrorTypeStatement = this.dbService.getSession().prepare("SELECT error_type FROM error_types WHERE task_id = ? ");
        this.selectErrorTypeStatement = this.dbService.getSession().prepare(String.format("select * from %s where %s = ? and %s = ?", "error_types", "task_id", "error_type"));
        this.selectErrorTypesStatement = this.dbService.getSession().prepare("SELECT * FROM error_types WHERE task_id = ?");
        this.selectErrorNotificationStatement = this.dbService.getSession().prepare("SELECT *  FROM error_notifications WHERE task_id = ? AND error_type = ? LIMIT 1");
        this.selectErrorNotificationsWithGivenLimitStatement = this.dbService.getSession().prepare("SELECT *  FROM error_notifications WHERE task_id = ? AND error_type = ? LIMIT ?");
        this.removeErrorCountsStatement = this.dbService.getSession().prepare("DELETE FROM error_types WHERE task_id = ? ");
        this.removeErrorNotifications = this.dbService.getSession().prepare("DELETE FROM error_notifications WHERE task_id = ? AND error_type = ?");
    }
}

