/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import eu.europeana.cloud.service.dps.storm.dao.CassandraDAO;
import java.util.List;
import java.util.stream.Collectors;

@Retryable(maxAttempts=7)
public class CassandraNodeStatisticsDAO
extends CassandraDAO {
    private static CassandraNodeStatisticsDAO instance = null;
    private PreparedStatement updateNodeStatement;
    private PreparedStatement searchNodesStatement;
    private PreparedStatement searchNodesStatementAll;
    private PreparedStatement deleteNodesStatisticsStatement;

    public CassandraNodeStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    public CassandraNodeStatisticsDAO() {
    }

    public static synchronized CassandraNodeStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = (CassandraNodeStatisticsDAO)RetryableMethodExecutor.createRetryProxy((Object)new CassandraNodeStatisticsDAO(cassandra));
        }
        return instance;
    }

    @Override
    protected void prepareStatements() {
        this.updateNodeStatement = this.dbService.getSession().prepare("UPDATE node_statistics SET occurrence = occurrence + ? WHERE task_id = ? AND node_xpath = ? AND node_value = ?");
        this.searchNodesStatement = this.dbService.getSession().prepare("SELECT * FROM node_statistics WHERE task_id = ? AND node_xpath = ? limit ?");
        this.searchNodesStatementAll = this.dbService.getSession().prepare("SELECT * FROM node_statistics WHERE task_id = ? AND node_xpath = ?");
        this.deleteNodesStatisticsStatement = this.dbService.getSession().prepare("DELETE FROM node_statistics WHERE task_id = ? AND node_xpath = ?");
    }

    public void updateNodeStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.dbService.getSession().execute((Statement)this.updateNodeStatement.bind(new Object[]{nodeStatistics.getOccurrence(), taskId, nodeStatistics.getXpath(), nodeStatistics.getValue()}));
    }

    public List<String> searchNodeStatisticsValues(long taskId, String nodeXpath) {
        return this.dbService.getSession().execute((Statement)this.searchNodesStatementAll.bind(new Object[]{taskId, nodeXpath})).all().stream().map(row -> row.getString("node_value")).collect(Collectors.toList());
    }

    public void removeNodeStatistics(long taskId, String nodeXpath) {
        this.dbService.getSession().execute((Statement)this.deleteNodesStatisticsStatement.bind(new Object[]{taskId, nodeXpath}));
    }

    public List<NodeStatistics> getNodeStatistics(long taskId, String parentXpath, String nodeXpath, int limit) {
        return this.dbService.getSession().execute((Statement)this.searchNodesStatement.bind(new Object[]{taskId, nodeXpath, limit})).all().stream().map(row -> this.createNodeStatistics(parentXpath, nodeXpath, (Row)row)).collect(Collectors.toList());
    }

    private NodeStatistics createNodeStatistics(String parentXpath, String nodeXpath, Row row) {
        return new NodeStatistics(parentXpath, nodeXpath, row.getString("node_value"), row.getLong("occurrence"));
    }
}

