/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;
import java.util.Date;

public class CassandraTaskInfoDAO
extends CassandraDAO {
    private PreparedStatement taskSearchStatement;
    private PreparedStatement taskInsertStatement;
    private PreparedStatement updateExpectedSize;
    private PreparedStatement updateTask;
    private PreparedStatement dropTask;
    private PreparedStatement endTask;
    private PreparedStatement updateProcessedFiles;
    private PreparedStatement killTask;
    private PreparedStatement setStatus;
    private PreparedStatement updateStatusExpectedSizeStatement;
    private static CassandraTaskInfoDAO instance = null;

    public static synchronized CassandraTaskInfoDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new CassandraTaskInfoDAO(cassandra);
        }
        return instance;
    }

    private CassandraTaskInfoDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    void prepareStatements() {
        this.taskSearchStatement = this.dbService.getSession().prepare("SELECT * FROM basic_info WHERE task_id = ?");
        this.taskSearchStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateTask = this.dbService.getSession().prepare("UPDATE basic_info SET state = ? , start_time = ? , info =? WHERE task_id = ?");
        this.updateTask.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateProcessedFiles = this.dbService.getSession().prepare("UPDATE basic_info SET processed_files_count = ? , errors = ? WHERE task_id = ?");
        this.updateProcessedFiles.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.endTask = this.dbService.getSession().prepare("UPDATE basic_info SET processed_files_count = ? , errors = ? , state = ? , finish_time = ? , info =? WHERE task_id = ?");
        this.endTask.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.taskInsertStatement = this.dbService.getSession().prepare("INSERT INTO basic_info(task_id,topology_name,expected_size,processed_files_count,state,info,sent_time,start_time,finish_time,errors,task_informations) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
        this.taskInsertStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.killTask = this.dbService.getSession().prepare("UPDATE basic_info SET state = ? , info = ? , finish_time = ?  WHERE task_id = ?");
        this.killTask.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateExpectedSize = this.dbService.getSession().prepare("UPDATE basic_info SET expected_size = ?  WHERE task_id = ?");
        this.updateExpectedSize.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.dropTask = this.dbService.getSession().prepare("UPDATE basic_info SET state = ? , info =? WHERE task_id = ?");
        this.dropTask.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.setStatus = this.dbService.getSession().prepare("UPDATE basic_info SET state = ? , info =? WHERE task_id = ?");
        this.setStatus.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateStatusExpectedSizeStatement = this.dbService.getSession().prepare("UPDATE basic_info SET state = ? , expected_size = ?  WHERE task_id = ?");
        this.updateStatusExpectedSizeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public TaskInfo searchById(long taskId) throws NoHostAvailableException, QueryExecutionException, TaskInfoDoesNotExistException {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.taskSearchStatement.bind(new Object[]{taskId}));
        if (!rs.iterator().hasNext()) {
            throw new TaskInfoDoesNotExistException();
        }
        Row row = rs.one();
        TaskInfo task = new TaskInfo(row.getLong("task_id"), row.getString("topology_name"), TaskState.valueOf((String)row.getString("state")), row.getString("info"), row.getDate("sent_time"), row.getDate("start_time"), row.getDate("finish_time"));
        task.setExpectedSize(row.getInt("expected_size"));
        task.setProcessedElementCount(row.getInt("processed_files_count"));
        task.setTaskDefinition(row.getString("task_informations"));
        return task;
    }

    public void insert(long taskId, String topologyName, int expectedSize, int processedFilesCount, String state, String info, Date sentTime, Date startTime, Date finishTime, int errors, String taskInformations) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.taskInsertStatement.bind(new Object[]{taskId, topologyName, expectedSize, processedFilesCount, state, info, sentTime, startTime, finishTime, errors, taskInformations}));
    }

    public void updateTask(long taskId, String info, String state, Date startDate) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateTask.bind(new Object[]{state, startDate, info, taskId}));
    }

    public void setTaskStatus(long taskId, String info, String state) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.setStatus.bind(new Object[]{state, info, taskId}));
    }

    public void dropTask(long taskId, String info, String state) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.dropTask.bind(new Object[]{state, info, taskId}));
    }

    public void setUpdateExpectedSize(long taskId, int expectedSize) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateExpectedSize.bind(new Object[]{expectedSize, taskId}));
    }

    public void endTask(long taskId, int processeFilesCount, int errors, String info, String state, Date finishDate) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.endTask.bind(new Object[]{processeFilesCount, errors, state, finishDate, info, taskId}));
    }

    public void insert(long taskId, String topologyName, int expectedSize, String state, String info, Date sentTime, String taskInformations) throws NoHostAvailableException, QueryExecutionException {
        this.insert(taskId, topologyName, expectedSize, 0, state, info, sentTime, null, null, 0, taskInformations);
    }

    public void startProgress(long taskId, String topologyName, int expectedSize, String state, String info, Date sentTime) throws NoHostAvailableException, QueryExecutionException {
        this.insert(taskId, topologyName, expectedSize, 0, state, info, sentTime, null, null, 0, null);
    }

    public void setUpdateProcessedFiles(long taskId, int processedFilesCount, int errors) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateProcessedFiles.bind(new Object[]{processedFilesCount, errors, taskId}));
    }

    public void killTask(long taskId, String info) {
        this.dbService.getSession().execute((Statement)this.killTask.bind(new Object[]{String.valueOf(TaskState.DROPPED), info, new Date(), taskId}));
    }

    public boolean hasKillFlag(long taskId) throws TaskInfoDoesNotExistException {
        String state = this.getTaskStatus(taskId);
        return state.equals(String.valueOf(TaskState.DROPPED));
    }

    private String getTaskStatus(long taskId) throws TaskInfoDoesNotExistException {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.taskSearchStatement.bind(new Object[]{taskId}));
        if (!rs.iterator().hasNext()) {
            throw new TaskInfoDoesNotExistException();
        }
        Row row = rs.one();
        return row.getString("state");
    }

    public void updateStatusExpectedSize(long taskId, String state, int expectedSize) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute((Statement)this.updateStatusExpectedSizeStatement.bind(new Object[]{state, expectedSize, taskId}));
    }
}

