/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;
import java.util.UUID;

public class CassandraTaskErrorsDAO
extends CassandraDAO {
    private PreparedStatement insertErrorStatement;
    private PreparedStatement updateErrorCounterStatement;
    private PreparedStatement selectErrorCountsStatement;
    private PreparedStatement removeErrorCountsStatement;
    private PreparedStatement removeErrorNotifications;
    private PreparedStatement selectErrorTypeStatement;
    private static CassandraTaskErrorsDAO instance = null;

    public static synchronized CassandraTaskErrorsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new CassandraTaskErrorsDAO(cassandra);
        }
        return instance;
    }

    private CassandraTaskErrorsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    void prepareStatements() {
        this.insertErrorStatement = this.dbService.getSession().prepare("INSERT INTO error_notifications(task_id,error_type,error_message,resource,additional_informations) VALUES (?,?,?,?,?)");
        this.insertErrorStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateErrorCounterStatement = this.dbService.getSession().prepare("UPDATE error_counters SET error_count = error_count + 1 WHERE task_id = ? AND error_type = ?");
        this.updateErrorCounterStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectErrorCountsStatement = this.dbService.getSession().prepare("SELECT error_count FROM error_counters WHERE task_id = ? ");
        this.selectErrorCountsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectErrorTypeStatement = this.dbService.getSession().prepare("SELECT error_type FROM error_counters WHERE task_id = ? ");
        this.selectErrorTypeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeErrorCountsStatement = this.dbService.getSession().prepare("DELETE  FROM error_counters WHERE task_id = ? ");
        this.removeErrorCountsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeErrorNotifications = this.dbService.getSession().prepare("DELETE  FROM error_notifications WHERE task_id = ? and error_type = ?");
        this.removeErrorNotifications.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void updateErrorCounter(long taskId, String errorType) {
        this.dbService.getSession().execute((Statement)this.updateErrorCounterStatement.bind(new Object[]{taskId, UUID.fromString(errorType)}));
    }

    public void insertError(long taskId, String errorType, String errorMessage, String resource, String additionalInformations) {
        this.dbService.getSession().execute((Statement)this.insertErrorStatement.bind(new Object[]{taskId, UUID.fromString(errorType), errorMessage, resource, additionalInformations}));
    }

    public int getErrorCount(long taskId) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.selectErrorCountsStatement.bind(new Object[]{taskId}));
        int count = 0;
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            count = (int)((long)count + row.getLong("error_count"));
        }
        return count;
    }

    public void removeErrors(long taskId) {
        ResultSet rs = this.dbService.getSession().execute((Statement)this.selectErrorTypeStatement.bind(new Object[]{taskId}));
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            UUID errorType = row.getUUID("error_type");
            this.dbService.getSession().execute((Statement)this.removeErrorNotifications.bind(new Object[]{taskId, errorType}));
        }
        this.dbService.getSession().execute((Statement)this.removeErrorCountsStatement.bind(new Object[]{taskId}));
    }
}

