/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.utils.files.counter;

import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.rest.exceptions.TaskSubmissionException;
import eu.europeana.cloud.service.dps.storm.utils.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.utils.files.counter.FilesCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetFilesCounter
extends FilesCounter {
    public static final int UNKNOWN_EXPECTED_SIZE = -1;
    private CassandraTaskInfoDAO taskDAO;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetFilesCounter.class);

    DatasetFilesCounter(CassandraTaskInfoDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public int getFilesCount(DpsTask task) throws TaskSubmissionException {
        String providedTaskId = task.getParameter("PREVIOUS_TASK_ID");
        if (providedTaskId == null) {
            return -1;
        }
        try {
            long taskId = Long.parseLong(providedTaskId);
            TaskInfo taskInfo = this.taskDAO.searchById(taskId);
            return taskInfo.getProcessedElementCount();
        }
        catch (NumberFormatException e) {
            LOGGER.error("The provided previous task id {} is not long  ", (Object)providedTaskId);
            return -1;
        }
        catch (TaskInfoDoesNotExistException e) {
            LOGGER.error("Task with taskId {} doesn't exist ", (Object)providedTaskId);
            return -1;
        }
        catch (Exception e) {
            LOGGER.error("he task was dropped because of {} ", (Object)e.getMessage());
            throw new TaskSubmissionException("The task was dropped while counting the files number because of " + e.getMessage());
        }
    }
}

