/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.rest.exceptionmappers;

import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrTopologyDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.DpsTaskValidationException;
import eu.europeana.cloud.service.dps.exception.TopologyAlreadyExistsException;
import eu.europeana.cloud.service.dps.rest.exceptions.TaskSubmissionException;
import eu.europeana.cloud.service.dps.status.DpsErrorCode;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

/*
 * Exception performing whole class analysis ignored.
 */
public class UnitedExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitedExceptionMapper.class);

    public Response toResponse(TopologyAlreadyExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (DpsErrorCode)DpsErrorCode.TOPOLOGY_ALREADY_EXIST, (Exception)exception);
    }

    public Response toResponse(ConstraintViolationException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.BAD_REQUEST, (DpsErrorCode)DpsErrorCode.BAD_REQUEST, (Exception)exception);
    }

    public Response toResponse(RuntimeException exception) {
        if (exception instanceof AccessDeniedException) {
            return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (DpsErrorCode)DpsErrorCode.ACCESS_DENIED_OR_OBJECT_DOES_NOT_EXIST_EXCEPTION, (Exception)exception);
        }
        LOGGER.error("Unexpected error occured.", (Throwable)exception);
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (DpsErrorCode)DpsErrorCode.OTHER, (Exception)exception);
    }

    public Response toResponse(WebApplicationException exception) {
        return UnitedExceptionMapper.buildResponse((int)exception.getResponse().getStatus(), (DpsErrorCode)DpsErrorCode.OTHER, (Exception)exception);
    }

    public Response toResponse(AccessDeniedOrTopologyDoesNotExistException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (DpsErrorCode)DpsErrorCode.ACCESS_DENIED_OR_TOPOLOGY_DOES_NOT_EXIST_EXCEPTION, (Exception)exception);
    }

    public Response toResponse(DpsTaskValidationException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.BAD_REQUEST, (DpsErrorCode)DpsErrorCode.TASK_NOT_VALID, (Exception)exception);
    }

    public Response toResponse(TaskSubmissionException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.BAD_REQUEST, (DpsErrorCode)DpsErrorCode.OTHER, (Exception)exception);
    }

    public Response toResponse(AccessDeniedOrObjectDoesNotExistException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (DpsErrorCode)DpsErrorCode.ACCESS_DENIED_OR_OBJECT_DOES_NOT_EXIST_EXCEPTION, (Exception)exception);
    }

    private static Response buildResponse(Response.Status httpStatus, DpsErrorCode errorCode, Exception e) {
        return UnitedExceptionMapper.buildResponse((int)httpStatus.getStatusCode(), (DpsErrorCode)errorCode, (Exception)e);
    }

    private static Response buildResponse(int httpStatusCode, DpsErrorCode errorCode, Exception e) {
        return Response.status((int)httpStatusCode).type("application/xml").entity((Object)new ErrorInfo(errorCode.name(), e.getMessage())).build();
    }
}

