/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.utils.files.counter;

import com.google.common.base.Throwables;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.OAIPMHHarvestingDetails;
import eu.europeana.cloud.service.dps.rest.exceptions.TaskSubmissionException;
import eu.europeana.cloud.service.dps.storm.utils.OAIResponseParseException;
import eu.europeana.cloud.service.dps.utils.files.counter.FilesCounter;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.HttpOAIClient;
import org.dspace.xoai.serviceprovider.exceptions.OAIRequestException;
import org.dspace.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class OaiPmhFilesCounter
extends FilesCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OaiPmhFilesCounter.class);
    private static final String COMPLETE_LIST_SIZE_XPATH = "/*[local-name()='OAI-PMH']/*[local-name()='ListIdentifiers']/*[local-name()='resumptionToken']";
    public static final String COMPLETE_LIST_SIZE = "completeListSize";
    private static final int DEFAULT_LIST_SIZE = -1;
    private static final int DEFAULT_RETRIES = 3;
    private static final int SLEEP_TIME = 5000;

    public int getFilesCount(DpsTask task) throws TaskSubmissionException {
        OAIPMHHarvestingDetails harvestingDetails = task.getHarvestingDetails();
        if (harvestingDetails != null) {
            if (this.specified(harvestingDetails.getExcludedSets()) || this.specified(harvestingDetails.getExcludedSchemas())) {
                LOGGER.info("Cannot count completeListSize for taskId= {} . Excluded sets or schemas are not supported", (Object)task.getTaskId());
                return -1;
            }
            String repositoryUrl = this.getRepositoryUrl(task.getInputData());
            if (repositoryUrl != null) {
                ListIdentifiersParameters params = new ListIdentifiersParameters().withFrom(harvestingDetails.getDateFrom()).withUntil(harvestingDetails.getDateUntil());
                Set schemas = harvestingDetails.getSchemas();
                Set sets = harvestingDetails.getSets();
                if (this.specified(sets)) {
                    if (sets.size() == 1) {
                        params.withSetSpec((String)sets.iterator().next());
                    } else {
                        LOGGER.info("Cannot count completeListSize for taskId= {} . Specifying multiple sets is not supported ", (Object)task.getTaskId());
                        return -1;
                    }
                }
                try {
                    return this.getListSizeForSchemasAndSet(repositoryUrl, params, schemas);
                }
                catch (OAIResponseParseException e) {
                    LOGGER.info("Cannot count completeListSize for taskId= {}", (Object)task.getTaskId(), (Object)e);
                    return -1;
                }
                catch (OAIRequestException e) {
                    String logMessage = "Cannot complete the request for the following repository URL " + repositoryUrl;
                    LOGGER.info(logMessage, (Throwable)e);
                    throw new TaskSubmissionException(logMessage + " Because: " + e.getMessage());
                }
            }
            throw new TaskSubmissionException("The task was dropped because the repositoryUrl can not be null");
        }
        return -1;
    }

    private String getRepositoryUrl(Map<InputDataType, List<String>> inputData) {
        List<String> urls = inputData.get(InputDataType.REPOSITORY_URLS);
        if (urls != null && !urls.isEmpty()) {
            return urls.get(0);
        }
        return null;
    }

    private int getListSizeForSchemasAndSet(String repositoryUrl, ListIdentifiersParameters params, Set<String> schemas) throws OAIRequestException, OAIResponseParseException {
        int sum = 0;
        if (this.specified(schemas)) {
            for (String schema : schemas) {
                params.withMetadataPrefix(schema);
                sum += this.getSizeForSchemaAndSet(repositoryUrl, params);
            }
        } else {
            sum = this.getSizeForSchemaAndSet(repositoryUrl, params);
        }
        return sum;
    }

    private int getSizeForSchemaAndSet(String repositoryUrl, ListIdentifiersParameters params) throws OAIResponseParseException, OAIRequestException {
        int retries = 3;
        while (true) {
            try {
                HttpOAIClient client = new HttpOAIClient(repositoryUrl);
                InputStream listIdentifiersResponse = client.execute(Parameters.parameters().withVerb(Verb.Type.ListIdentifiers).include(params));
                return this.readCompleteListSizeFromXML(listIdentifiersResponse);
            }
            catch (OAIRequestException e) {
                if (retries-- > 0) {
                    LOGGER.warn("Checking CompleteListSize. Retries left: {} ", (Object)retries);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        LOGGER.error(Throwables.getStackTraceAsString((Throwable)e));
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private int readCompleteListSizeFromXML(InputStream stream) throws OAIResponseParseException {
        InputSource inputSource = new SAXSource(new InputSource(stream)).getInputSource();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(COMPLETE_LIST_SIZE_XPATH);
            Node resumptionTokenNode = (Node)expr.evaluate(inputSource, XPathConstants.NODE);
            if (resumptionTokenNode != null) {
                Node node = resumptionTokenNode.getAttributes().getNamedItem(COMPLETE_LIST_SIZE);
                if (node != null) {
                    String completeListSize = node.getNodeValue();
                    return Integer.parseInt(completeListSize);
                }
                throw new OAIResponseParseException("Cannot read completeListSize from OAI response. No resumption token node.");
            }
            throw new OAIResponseParseException("Cannot read completeListSize from OAI response. No resumption token node.");
        }
        catch (NumberFormatException | XPathExpressionException e) {
            throw new OAIResponseParseException("Cannot read completeListSize from OAI response ", (Throwable)e);
        }
    }

    private boolean specified(Set<String> strings) {
        return strings != null && !strings.isEmpty();
    }
}

