/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.utils.files.counter;

import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.storm.utils.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.utils.files.counter.DatasetFilesCounter;
import eu.europeana.cloud.service.dps.utils.files.counter.FilesCounter;
import eu.europeana.cloud.service.dps.utils.files.counter.OaiPmhFilesCounter;
import eu.europeana.cloud.service.dps.utils.files.counter.RecordFilesCounter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilesCounterFactory {
    @Autowired
    private CassandraTaskInfoDAO taskDAO;

    public FilesCounter createFilesCounter(String taskType) {
        if (InputDataType.FILE_URLS.name().equals(taskType)) {
            return new RecordFilesCounter();
        }
        if (InputDataType.DATASET_URLS.name().equals(taskType)) {
            return new DatasetFilesCounter(this.taskDAO);
        }
        if (InputDataType.REPOSITORY_URLS.name().equals(taskType)) {
            return new OaiPmhFilesCounter();
        }
        return null;
    }
}

