/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.task;

import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.service.utils.indexing.IndexingSettingsGenerator;
import eu.europeana.cloud.service.dps.service.utils.validation.TargetIndexingDatabase;
import eu.europeana.cloud.service.dps.service.utils.validation.TargetIndexingEnvironment;
import eu.europeana.cloud.service.dps.task.InitialActionException;
import eu.europeana.cloud.service.dps.task.TaskInitialActionsExecutor;
import eu.europeana.indexing.IndexerFactory;
import eu.europeana.indexing.IndexingSettings;
import eu.europeana.indexing.exception.IndexingException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingTaskInitialActionsExecutor
implements TaskInitialActionsExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingTaskInitialActionsExecutor.class);
    private DpsTask dpsTask;
    private IndexerFactory indexerFactory;
    private Properties properties = new Properties();

    public IndexingTaskInitialActionsExecutor(DpsTask task) {
        this.dpsTask = task;
        this.loadProperties();
    }

    public void execute() throws InitialActionException {
        LOGGER.info("Executing initial actions for indexing topology");
        if (this.properties.isEmpty()) {
            return;
        }
        this.prepareIndexerFactory();
        try {
            this.removeDataSet(this.dpsTask.getParameter("METIS_DATASET_ID"));
        }
        catch (IndexingException e) {
            LOGGER.error("Dataset was not removed correctly. ", (Throwable)e);
            throw new InitialActionException("Dataset was not removed correctly.", (Throwable)e);
        }
    }

    private void loadProperties() {
        try {
            InputStream input = IndexingTaskInitialActionsExecutor.class.getClassLoader().getResourceAsStream("indexing.properties");
            this.properties.load(input);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to read indexing.properties (are you sure that file exists?). Dataset will not  be cleared before indexing.");
        }
    }

    private void prepareIndexerFactory() {
        LOGGER.debug("Preparing IndexerFactory for removing datasets from Solr and Mongo");
        String altEnv = this.dpsTask.getParameter("USE_ALT_INDEXING_ENV");
        String database = this.dpsTask.getParameter("TARGET_INDEXING_DATABASE");
        IndexingSettings indexingSettings = null;
        try {
            if (altEnv != null && altEnv.equalsIgnoreCase("true")) {
                IndexingSettingsGenerator s1 = new IndexingSettingsGenerator(TargetIndexingEnvironment.ALTERNATIVE, this.properties);
                if (TargetIndexingDatabase.PREVIEW.toString().equals(database)) {
                    indexingSettings = s1.generateForPreview();
                } else if (TargetIndexingDatabase.PUBLISH.toString().equals(database)) {
                    indexingSettings = s1.generateForPublish();
                }
            } else {
                IndexingSettingsGenerator s2 = new IndexingSettingsGenerator(this.properties);
                if (TargetIndexingDatabase.PREVIEW.toString().equals(database)) {
                    indexingSettings = s2.generateForPreview();
                } else if (TargetIndexingDatabase.PUBLISH.toString().equals(database)) {
                    indexingSettings = s2.generateForPublish();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create indexing factory");
        }
        this.indexerFactory = new IndexerFactory(indexingSettings);
    }

    private void removeDataSet(String datasetId) throws IndexingException {
        LOGGER.info("Removing data set {} from solr and mongo", (Object)datasetId);
        this.indexerFactory.getIndexer().removeAll(datasetId);
        LOGGER.info("Data set removed");
    }
}

