/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.dps.NodeReport;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.TaskExecutionKillService;
import eu.europeana.cloud.service.dps.TaskExecutionReportService;
import eu.europeana.cloud.service.dps.TaskExecutionSubmitService;
import eu.europeana.cloud.service.dps.ValidationStatisticsReportService;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrTopologyDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.DpsTaskValidationException;
import eu.europeana.cloud.service.dps.rest.exceptions.TaskSubmissionException;
import eu.europeana.cloud.service.dps.service.utils.TopologyManager;
import eu.europeana.cloud.service.dps.service.utils.validation.DpsTaskValidator;
import eu.europeana.cloud.service.dps.storm.utils.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.task.InitialActionException;
import eu.europeana.cloud.service.dps.task.InitialActionsExecutorFactory;
import eu.europeana.cloud.service.dps.utils.DpsTaskValidatorFactory;
import eu.europeana.cloud.service.dps.utils.PermissionManager;
import eu.europeana.cloud.service.dps.utils.files.counter.FilesCounter;
import eu.europeana.cloud.service.dps.utils.files.counter.FilesCounterFactory;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/{topologyName}/tasks")
@Component
@Scope(value="request")
public class TopologyTasksResource {
    @Value(value="${maxIdentifiersCount}")
    private int maxIdentifiersCount;
    @Autowired
    ApplicationContext context;
    @Autowired
    private TaskExecutionReportService reportService;
    @Autowired
    private ValidationStatisticsReportService validationStatisticsService;
    @Autowired
    private TaskExecutionSubmitService submitService;
    @Autowired
    private TaskExecutionKillService killService;
    @Autowired
    private TopologyManager topologyManager;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private String mcsLocation;
    @Autowired
    private RecordServiceClient recordServiceClient;
    @Autowired
    private FileServiceClient fileServiceClient;
    @Autowired
    private DataSetServiceClient dataSetServiceClient;
    @Autowired
    private CassandraTaskInfoDAO taskDAO;
    @Autowired
    private FilesCounterFactory filesCounterFactory;
    @Autowired
    private InitialActionsExecutorFactory initialActionsExecutorFactory;
    private static final String TOPOLOGY_PREFIX = "Topology";
    public static final String TASK_PREFIX = "DPS_Task";
    public static final String HTTP_TOPOLOGY = "http_topology";
    private static final int UNKNOWN_EXPECTED_SIZE = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyTasksResource.class);

    @GET
    @Path(value="{taskId}/progress")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    @Produces(value={"application/json", "application/xml"})
    public TaskInfo getTaskProgress(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrObjectDoesNotExistException, AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        this.reportService.checkIfTaskExists(taskId, topologyName);
        TaskInfo progress = this.reportService.getTaskProgress(taskId);
        return progress;
    }

    @POST
    @Consumes(value={"application/json"})
    @PreAuthorize(value="hasPermission(#topologyName,'Topology', write)")
    public Response submitTask(@Suspended AsyncResponse asyncResponse, DpsTask task, @PathParam(value="topologyName") String topologyName, @Context UriInfo uriInfo, @HeaderParam(value="Authorization") String authorizationHeader) throws AccessDeniedOrTopologyDoesNotExistException, DpsTaskValidationException {
        if (task != null) {
            LOGGER.info("Submitting task");
            this.assertContainTopology(topologyName);
            this.validateTask(task, topologyName);
            this.validateOutputDataSetsIfExist(task);
            Date sentTime = new Date();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        return Response.notModified().build();
    }

    private void validateOutputDataSetsIfExist(DpsTask task) throws DpsTaskValidationException {
        List dataSets = this.readDataSetsList(task.getParameter("OUTPUT_DATA_SETS"));
        if (dataSets != null) {
            for (String dataSetURL : dataSets) {
                try {
                    DataSet dataSet = this.parseDataSetURl(dataSetURL);
                    this.dataSetServiceClient.getDataSetRepresentationsChunk(dataSet.getProviderId(), dataSet.getId(), null);
                    this.validateProviderId(task, dataSet.getProviderId());
                }
                catch (MalformedURLException e) {
                    throw new DpsTaskValidationException("Validation failed. This output dataSet " + dataSetURL + " can not be submitted because: " + e.getMessage());
                }
                catch (DataSetNotExistsException e) {
                    throw new DpsTaskValidationException("Validation failed. This output dataSet " + dataSetURL + " Does not exist");
                }
                catch (Exception e) {
                    throw new DpsTaskValidationException("Unexpected exception happened while validating the dataSet: " + dataSetURL + " because of: " + e.getMessage());
                }
            }
        }
    }

    private void validateProviderId(DpsTask task, String providerId) throws DpsTaskValidationException {
        String providedProviderId = task.getParameter("PROVIDER_ID");
        if (providedProviderId != null && !providedProviderId.equals(providerId)) {
            throw new DpsTaskValidationException("Validation failed. The provider id: " + providedProviderId + " should be the same provider of the output dataSet: " + providerId);
        }
    }

    private List<String> readDataSetsList(String listParameter) {
        if (listParameter == null) {
            return null;
        }
        return Arrays.asList(listParameter.split(","));
    }

    private DataSet parseDataSetURl(String url) throws MalformedURLException {
        UrlParser parser = new UrlParser(url);
        if (parser.isUrlToDataset()) {
            DataSet dataSet = new DataSet();
            dataSet.setId(parser.getPart(UrlPart.DATA_SETS));
            dataSet.setProviderId(parser.getPart(UrlPart.DATA_PROVIDERS));
            return dataSet;
        }
        throw new MalformedURLException("The dataSet URL is not formulated correctly");
    }

    @GET
    @Path(value="{taskId}/reports/details")
    @Produces(value={"application/json", "application/xml"})
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public List<SubTaskInfo> getTaskDetailedReport(@PathParam(value="taskId") String taskId, @PathParam(value="topologyName") String topologyName, @Min(value=1L) @DefaultValue(value="1") @QueryParam(value="from") int from, @Min(value=1L) @DefaultValue(value="100") @QueryParam(value="to") int to) throws AccessDeniedOrTopologyDoesNotExistException, AccessDeniedOrObjectDoesNotExistException {
        this.assertContainTopology(topologyName);
        this.reportService.checkIfTaskExists(taskId, topologyName);
        List taskInfo = this.reportService.getDetailedTaskReportBetweenChunks(taskId, from, to);
        return taskInfo;
    }

    @GET
    @Path(value="{taskId}/reports/errors")
    @Produces(value={"application/json", "application/xml"})
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public TaskErrorsInfo getTaskErrorReport(@PathParam(value="taskId") String taskId, @PathParam(value="topologyName") String topologyName, @QueryParam(value="error") String error, @DefaultValue(value="0") @QueryParam(value="idsCount") int idsCount) throws AccessDeniedOrTopologyDoesNotExistException, AccessDeniedOrObjectDoesNotExistException {
        this.assertContainTopology(topologyName);
        this.reportService.checkIfTaskExists(taskId, topologyName);
        if (idsCount < 0 || idsCount > this.maxIdentifiersCount) {
            throw new IllegalArgumentException("Identifiers count parameter should be between 0 and " + this.maxIdentifiersCount);
        }
        if (error == null) {
            return this.reportService.getGeneralTaskErrorReport(taskId, idsCount);
        }
        return this.reportService.getSpecificTaskErrorReport(taskId, error, idsCount > 0 ? idsCount : this.maxIdentifiersCount);
    }

    @HEAD
    @Path(value="{taskId}/reports/errors")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public Boolean checkIfErrorReportExists(@PathParam(value="taskId") String taskId, @PathParam(value="topologyName") String topologyName) throws AccessDeniedOrTopologyDoesNotExistException, AccessDeniedOrObjectDoesNotExistException {
        this.assertContainTopology(topologyName);
        this.reportService.checkIfTaskExists(taskId, topologyName);
        return this.reportService.checkIfReportExists(taskId);
    }

    @GET
    @Path(value="{taskId}/statistics")
    @Produces(value={"application/json", "application/xml"})
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public StatisticsReport getTaskStatisticsReport(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrTopologyDoesNotExistException, AccessDeniedOrObjectDoesNotExistException {
        this.assertContainTopology(topologyName);
        this.reportService.checkIfTaskExists(taskId, topologyName);
        return this.validationStatisticsService.getTaskStatisticsReport(Long.parseLong(taskId));
    }

    @GET
    @Path(value="{taskId}/reports/element")
    @Produces(value={"application/json", "application/xml"})
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public List<NodeReport> getElementsValues(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId, @NotNull @QueryParam(value="path") String elementPath) throws AccessDeniedOrTopologyDoesNotExistException, AccessDeniedOrObjectDoesNotExistException {
        this.assertContainTopology(topologyName);
        this.reportService.checkIfTaskExists(taskId, topologyName);
        return this.validationStatisticsService.getElementReport(Long.parseLong(taskId), elementPath);
    }

    @POST
    @Path(value="{taskId}/permit")
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @ReturnType(value="java.lang.Void")
    public Response grantPermissions(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId, @FormParam(value="username") String username) throws AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        if (taskId != null) {
            this.permissionManager.grantPermissionsForTask(taskId, username);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    @POST
    @Path(value="{taskId}/kill")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', write)")
    public Response killTask(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId, @QueryParam(value="info") @DefaultValue(value="Dropped by the user") String info) throws AccessDeniedOrTopologyDoesNotExistException, AccessDeniedOrObjectDoesNotExistException {
        this.assertContainTopology(topologyName);
        this.reportService.checkIfTaskExists(taskId, topologyName);
        this.killService.killTask(Long.parseLong(taskId), info);
        return Response.ok((Object)("The task was killed because of " + info)).build();
    }

    private String buildTaskUrl(UriInfo uriInfo, DpsTask task, String topologyName) {
        StringBuilder taskUrl = new StringBuilder().append(uriInfo.getBaseUri().toString()).append(topologyName).append("/tasks/").append(task.getTaskId());
        return taskUrl.toString();
    }

    private void assertContainTopology(String topology) throws AccessDeniedOrTopologyDoesNotExistException {
        if (!this.topologyManager.containsTopology(topology)) {
            throw new AccessDeniedOrTopologyDoesNotExistException("The topology doesn't exist");
        }
    }

    private void validateTask(DpsTask task, String topologyName) throws DpsTaskValidationException {
        String taskType = this.specifyTaskType(task, topologyName);
        DpsTaskValidator validator = DpsTaskValidatorFactory.createValidator((String)taskType);
        validator.validate(task);
    }

    private String specifyTaskType(DpsTask task, String topologyName) throws DpsTaskValidationException {
        if (task.getDataEntry(InputDataType.FILE_URLS) != null) {
            return topologyName + "_" + InputDataType.FILE_URLS.name().toLowerCase();
        }
        if (task.getDataEntry(InputDataType.DATASET_URLS) != null) {
            return topologyName + "_" + InputDataType.DATASET_URLS.name().toLowerCase();
        }
        if (task.getDataEntry(InputDataType.REPOSITORY_URLS) != null) {
            return topologyName + "_" + InputDataType.REPOSITORY_URLS.name().toLowerCase();
        }
        throw new DpsTaskValidationException("Validation failed. Missing required data_entry");
    }

    private int getFilesCountInsideTask(DpsTask submittedTask, String topologyName) throws TaskSubmissionException {
        if (topologyName.equals(HTTP_TOPOLOGY)) {
            return -1;
        }
        String taskType = this.getTaskType(submittedTask);
        FilesCounter filesCounter = this.filesCounterFactory.createFilesCounter(taskType);
        return filesCounter.getFilesCount(submittedTask);
    }

    private void runTaskSpecificActions(DpsTask task, String topologyName) throws InitialActionException {
        this.initialActionsExecutorFactory.get(task, topologyName).execute();
    }

    private String getTaskType(DpsTask task) {
        InputDataType first = (InputDataType)task.getInputData().keySet().iterator().next();
        return first.name();
    }

    static /* synthetic */ String access$000(TopologyTasksResource x0, UriInfo x1, DpsTask x2, String x3) {
        return x0.buildTaskUrl(x1, x2, x3);
    }

    static /* synthetic */ CassandraTaskInfoDAO access$100(TopologyTasksResource x0) {
        return x0.taskDAO;
    }

    static /* synthetic */ PermissionManager access$200(TopologyTasksResource x0) {
        return x0.permissionManager;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ int access$400(TopologyTasksResource x0, DpsTask x1, String x2) throws TaskSubmissionException {
        return x0.getFilesCountInsideTask(x1, x2);
    }

    static /* synthetic */ void access$500(TopologyTasksResource x0, DpsTask x1, String x2) throws InitialActionException {
        x0.runTaskSpecificActions(x1, x2);
    }

    static /* synthetic */ TaskExecutionSubmitService access$600(TopologyTasksResource x0) {
        return x0.submitService;
    }
}

