/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.utils.permissionmanager;

import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.rest.exceptions.TaskSubmissionException;
import eu.europeana.cloud.service.dps.utils.permissionmanager.ResourcePermissionManager;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class RecordPermissionManager
extends ResourcePermissionManager {
    RecordPermissionManager(ApplicationContext context) {
        super(context);
    }

    public int grantPermissionsToTaskResources(DpsTask task, String topologyName, String topologyUserName, String authorizationHeader) throws TaskSubmissionException {
        List fileUrls = (List)task.getInputData().get("FILE_URLS");
        int size = fileUrls.size();
        for (String fileUrl : fileUrls) {
            try {
                UrlParser parser = new UrlParser(fileUrl);
                this.grantPermissionToVersion(authorizationHeader, topologyUserName, parser.getPart(UrlPart.RECORDS), parser.getPart(UrlPart.REPRESENTATIONS), parser.getPart(UrlPart.VERSIONS));
                LOGGER.info("Permissions granted to: {}", (Object)fileUrl);
            }
            catch (MalformedURLException e) {
                LOGGER.error("URL in task's file list is malformed. Submission terminated. Wrong entry: " + fileUrl);
                throw new TaskSubmissionException("Malformed URL in task: " + fileUrl + ". Submission process stopped.");
            }
            catch (MCSException e) {
                LOGGER.error("Error while communicating MCS", (Throwable)e);
                throw new TaskSubmissionException("Error while communicating MCS. " + e.getMessage() + " for: " + fileUrl + ". Submission process stopped.");
            }
            catch (Exception e) {
                LOGGER.error("an exception happened !! " + e.getMessage());
                throw new RuntimeException(e.getMessage() + ". Submission process stopped");
            }
        }
        return size;
    }
}

