/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.utils.permissionmanager;

import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.rest.exceptions.TaskSubmissionException;
import eu.europeana.cloud.service.dps.utils.permissionmanager.ResourcePermissionManager;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class DatasetPermissionManager
extends ResourcePermissionManager {
    DatasetPermissionManager(ApplicationContext context) {
        super(context);
    }

    public int grantPermissionsToTaskResources(DpsTask task, String topologyName, String topologyUserName, String authorizationHeader) throws TaskSubmissionException {
        int size = 0;
        List dataSets = (List)task.getInputData().get("DATASET_URLS");
        String representationName = task.getParameter("REPRESENTATION_NAME");
        DataSetServiceClient dataSetServiceClient = (DataSetServiceClient)this.context.getBean(DataSetServiceClient.class);
        for (String dataSet : dataSets) {
            try {
                UrlParser urlParser = new UrlParser(dataSet);
                List representations = dataSetServiceClient.useAuthorizationHeader(authorizationHeader).getDataSetRepresentations(urlParser.getPart(UrlPart.DATA_PROVIDERS), urlParser.getPart(UrlPart.DATA_SETS));
                for (Representation representation : representations) {
                    if (representationName != null && !representation.getRepresentationName().equals(representationName)) continue;
                    this.grantPermissionToVersion(authorizationHeader, topologyUserName, representation.getCloudId(), representation.getRepresentationName(), representation.getVersion());
                    size += representation.getFiles().size();
                }
            }
            catch (DataSetNotExistsException ex) {
                LOGGER.warn("Provided dataset is not existed {}", (Object)dataSet);
                throw new TaskSubmissionException("Provided dataset is not existed: " + dataSet + ". Submission process stopped.");
            }
            catch (MalformedURLException ex) {
                LOGGER.error("URL in task's dataset list is malformed. Submission terminated. Wrong entry: " + dataSet);
                throw new TaskSubmissionException("Malformed URL in task: " + dataSet + ". Submission process stopped.");
            }
            catch (MCSException ex) {
                LOGGER.error("Error while communicating MCS", (Throwable)ex);
                throw new TaskSubmissionException("Error while communicating MCS. " + ex.getMessage() + " for: " + dataSet + ". Submission process stopped.");
            }
            catch (Exception ex) {
                LOGGER.error("an exception happened !! " + ex.getMessage());
                throw new RuntimeException(ex.getMessage() + ". Submission process stopped");
            }
        }
        return size;
    }
}

