/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.utils;

import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Component
public class PermissionManager {
    @Autowired
    private MutableAclService mutableAclService;

    public void grantPermissionsForTask(String taskId) {
        this.grantPermissionsForTask(taskId, SpringUserUtils.getUsername());
    }

    public void grantPermissionsForTask(String taskId, String username) {
        MutableAcl taskAcl = null;
        ObjectIdentityImpl taskObjectIdentity = new ObjectIdentityImpl("DPS_Task", (Serializable)((Object)taskId));
        try {
            taskAcl = (MutableAcl)this.mutableAclService.readAclById((ObjectIdentity)taskObjectIdentity);
        }
        catch (NotFoundException e) {
            taskAcl = this.mutableAclService.createAcl((ObjectIdentity)taskObjectIdentity);
        }
        taskAcl.insertAce(taskAcl.getEntries().size(), BasePermission.WRITE, (Sid)new PrincipalSid(username), true);
        taskAcl.insertAce(taskAcl.getEntries().size(), BasePermission.READ, (Sid)new PrincipalSid(username), true);
        this.mutableAclService.updateAcl(taskAcl);
    }
}

