/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.utils;

import eu.europeana.cloud.service.dps.service.utils.validation.DpsTaskValidator;
import eu.europeana.cloud.service.dps.service.utils.validation.InputDataValueType;

public class DpsTaskValidatorFactory {
    private static final DpsTaskValidator EMPTY_VALIDATOR = new DpsTaskValidator();
    private static final String XSLT_TOPOLOGY_TASK_WITH_FILE_URLS = "xslt_topology_file_urls";
    private static final String XSLT_TOPOLOGY_TASK_WITH_FILE_DATASETS = "xslt_topology_dataset_urls";
    private static final String IC_TOPOLOGY_TASK_WITH_FILE_URLS = "ic_topology_file_urls";
    private static final String IC_TOPOLOGY_TASK_WITH_DATASETS = "ic_topology_dataset_urls";

    public static DpsTaskValidator createValidator(String taskType) {
        if (taskType.equalsIgnoreCase(XSLT_TOPOLOGY_TASK_WITH_FILE_URLS)) {
            DpsTaskValidator validator = new DpsTaskValidator("FileUrl validator for XSLT Topology").withParameter("XSLT_URL").withParameter("TASK_SUBMITTER_NAME").withDataEntry("FILE_URLS", InputDataValueType.LINK_TO_FILE);
            return validator;
        }
        if (taskType.equalsIgnoreCase(XSLT_TOPOLOGY_TASK_WITH_FILE_DATASETS)) {
            DpsTaskValidator validator = new DpsTaskValidator("DataSet validator for XSLT Topology").withParameter("XSLT_URL").withParameter("TASK_SUBMITTER_NAME").withDataEntry("DATASET_URLS", InputDataValueType.LINK_TO_DATASET);
            return validator;
        }
        if (taskType.equalsIgnoreCase(IC_TOPOLOGY_TASK_WITH_FILE_URLS)) {
            DpsTaskValidator validator = new DpsTaskValidator("FileUrl validator for IC Topology").withParameter("MIME_TYPE").withParameter("OUTPUT_MIME_TYPE").withParameter("TASK_SUBMITTER_NAME").withDataEntry("FILE_URLS", InputDataValueType.LINK_TO_FILE);
            return validator;
        }
        if (taskType.equalsIgnoreCase(IC_TOPOLOGY_TASK_WITH_DATASETS)) {
            DpsTaskValidator validator = new DpsTaskValidator("DataSet validator for IC Topology").withParameter("MIME_TYPE").withParameter("OUTPUT_MIME_TYPE").withParameter("TASK_SUBMITTER_NAME").withDataEntry("DATASET_URLS", InputDataValueType.LINK_TO_DATASET);
            return validator;
        }
        return EMPTY_VALIDATOR;
    }
}

