/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.TaskExecutionKillService;
import eu.europeana.cloud.service.dps.TaskExecutionReportService;
import eu.europeana.cloud.service.dps.TaskExecutionSubmitService;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrTopologyDoesNotExistException;
import eu.europeana.cloud.service.dps.rest.exceptions.TaskSubmissionException;
import eu.europeana.cloud.service.dps.service.utils.TopologyManager;
import eu.europeana.cloud.service.dps.service.utils.validation.DpsTaskValidationException;
import eu.europeana.cloud.service.dps.service.utils.validation.DpsTaskValidator;
import eu.europeana.cloud.service.dps.storm.utils.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.utils.DpsTaskValidatorFactory;
import eu.europeana.cloud.service.dps.utils.PermissionManager;
import eu.europeana.cloud.service.dps.utils.permissionmanager.PermissionManagerFactory;
import eu.europeana.cloud.service.dps.utils.permissionmanager.ResourcePermissionManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.server.ManagedAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/topologies/{topologyName}/tasks")
@Component
public class TopologyTasksResource {
    @Autowired
    ApplicationContext context;
    @Autowired
    private TaskExecutionReportService reportService;
    @Autowired
    private TaskExecutionSubmitService submitService;
    @Autowired
    private TaskExecutionKillService killService;
    @Autowired
    private TopologyManager topologyManager;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private String mcsLocation;
    @Autowired
    private RecordServiceClient recordServiceClient;
    @Autowired
    private FileServiceClient fileServiceClient;
    @Autowired
    private DataSetServiceClient dataSetServiceClient;
    @Autowired
    private CassandraTaskInfoDAO taskDAO;
    private static final String TOPOLOGY_PREFIX = "Topology";
    public static final String TASK_PREFIX = "DPS_Task";
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyTasksResource.class);

    @GET
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{taskId}")
    public DpsTask getTask(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        LOGGER.info("Fetching task");
        DpsTask task = this.submitService.fetchTask(topologyName, Long.valueOf(taskId).longValue());
        return task;
    }

    @GET
    @Path(value="{taskId}/progress")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    @ReturnType(value="java.lang.String")
    public Response getTaskProgress(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrObjectDoesNotExistException, AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        String progress = this.reportService.getTaskProgress(taskId);
        return Response.ok((Object)progress).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @PreAuthorize(value="hasPermission(#topologyName,'Topology', write)")
    @ManagedAsync
    @Path(value="/")
    public Response submitTask(@Suspended AsyncResponse asyncResponse, DpsTask task, @PathParam(value="topologyName") String topologyName, @Context UriInfo uriInfo, @HeaderParam(value="Authorization") String authorizationHeader) throws AccessDeniedOrTopologyDoesNotExistException, DpsTaskValidationException {
        if (task != null) {
            LOGGER.info("Submitting task");
            this.assertContainTopology(topologyName);
            this.validateTask(task, topologyName);
            try {
                String createdTaskUrl = this.buildTaskUrl(uriInfo, task, topologyName);
                Response response = Response.created((URI)new URI(createdTaskUrl)).build();
                this.taskDAO.insert(task.getTaskId(), topologyName, 0, TaskState.PENDING.toString(), "The task is in a pending mode, it is being processed before submission");
                asyncResponse.resume((Object)response);
                LOGGER.info("The task is in a pending mode");
                int expectedSize = this.grantPermissionsToTaskResources(topologyName, authorizationHeader, task);
                task.addParameter("EXPECTED_SIZE", String.valueOf(expectedSize));
                this.submitService.submitTask(task, topologyName);
                this.permissionManager.grantPermissionsForTask(String.valueOf(task.getTaskId()));
                LOGGER.info("Task submitted successfully");
                this.taskDAO.insert(task.getTaskId(), topologyName, expectedSize, TaskState.SENT.toString(), "");
            }
            catch (URISyntaxException e) {
                LOGGER.error("Task submission failed");
                e.printStackTrace();
                Response response = Response.serverError().build();
                this.taskDAO.insert(task.getTaskId(), topologyName, 0, TaskState.DROPPED.toString(), e.getMessage());
                asyncResponse.resume((Object)response);
            }
            catch (TaskSubmissionException e) {
                LOGGER.error("Task submission failed" + e.getMessage());
                this.taskDAO.insert(task.getTaskId(), topologyName, 0, TaskState.DROPPED.toString(), e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                LOGGER.error("Task submission failed." + e.getMessage());
                this.taskDAO.insert(task.getTaskId(), topologyName, 0, TaskState.DROPPED.toString(), e.getMessage());
                e.printStackTrace();
                Response response = Response.serverError().build();
                asyncResponse.resume((Object)response);
            }
        }
        return Response.notModified().build();
    }

    @GET
    @Path(value="{taskId}/notification")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public String getTaskNotification(@PathParam(value="taskId") String taskId) {
        String progress = this.reportService.getTaskNotification(taskId);
        return progress;
    }

    @POST
    @Path(value="{taskId}/permit")
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @ReturnType(value="java.lang.Void")
    public Response grantPermissions(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId, @FormParam(value="username") String username) throws AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        if (taskId != null) {
            this.permissionManager.grantPermissionsForTask(taskId, username);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    @POST
    @Path(value="{taskId}/kill")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', write)")
    @ReturnType(value="java.lang.Void")
    public Response killTask(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        if (taskId != null) {
            this.killService.killTask(topologyName, Long.valueOf(taskId).longValue());
            this.killService.cleanOldFlags(topologyName, TimeUnit.DAYS.toMillis(5L));
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    @GET
    @Path(value="{taskId}/kill")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public Boolean checkKillFlag(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        return this.killService.hasKillFlag(topologyName, Long.valueOf(taskId).longValue());
    }

    @DELETE
    @Path(value="{taskId}/kill")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', write)")
    @ReturnType(value="java.lang.Void")
    public Response removeKillFlag(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrTopologyDoesNotExistException {
        this.assertContainTopology(topologyName);
        if (taskId != null && topologyName != null) {
            this.killService.removeFlag(topologyName, Long.valueOf(taskId).longValue());
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    private String buildTaskUrl(UriInfo uriInfo, DpsTask task, String topologyName) {
        StringBuilder taskUrl = new StringBuilder().append(uriInfo.getBaseUri().toString()).append("topologies/").append(topologyName).append("/tasks/").append(task.getTaskId());
        return taskUrl.toString();
    }

    private void assertContainTopology(String topology) throws AccessDeniedOrTopologyDoesNotExistException {
        if (!this.topologyManager.containsTopology(topology)) {
            throw new AccessDeniedOrTopologyDoesNotExistException();
        }
    }

    private void validateTask(DpsTask task, String topologyName) throws DpsTaskValidationException {
        String taskType = this.specifyTaskType(task, topologyName);
        DpsTaskValidator validator = DpsTaskValidatorFactory.createValidator((String)taskType);
        validator.validate(task);
    }

    private String specifyTaskType(DpsTask task, String topologyName) throws DpsTaskValidationException {
        if (task.getDataEntry("FILE_URLS") != null) {
            return topologyName + "_" + "FILE_URLS".toLowerCase();
        }
        if (task.getDataEntry("DATASET_URLS") != null) {
            return topologyName + "_" + "DATASET_URLS".toLowerCase();
        }
        throw new DpsTaskValidationException("Validation failed. Missing required data_entry");
    }

    private int grantPermissionsToTaskResources(String topologyName, String authorizationHeader, DpsTask submittedTask) throws TaskSubmissionException {
        LOGGER.info("Granting permissions to files from DPS task");
        String topologyUserName = (String)this.topologyManager.getNameToUserMap().get(topologyName);
        if (topologyUserName == null) {
            LOGGER.error("There is no user for topology '{}' in users map. Permissions will not be granted.", (Object)topologyName);
            throw new TaskSubmissionException("There is no user for topology" + topologyName + " in users map. Permissions will not be granted.");
        }
        int recordsInsideTask = 0;
        PermissionManagerFactory permissionManagerFactory = new PermissionManagerFactory(this.context);
        String taskType = this.getTaskType(submittedTask);
        ResourcePermissionManager resourcePermissionManager = permissionManagerFactory.createPermissionManager(taskType);
        recordsInsideTask = resourcePermissionManager.grantPermissionsToTaskResources(submittedTask, topologyName, topologyUserName, authorizationHeader);
        return recordsInsideTask;
    }

    private String getTaskType(DpsTask task) {
        if (task.getInputData().get("FILE_URLS") != null) {
            return "FILE_URLS";
        }
        return "DATASET_URLS";
    }
}

