/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.rest.exceptionmappers;

import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.dps.exception.TopologyAlreadyExistsException;
import eu.europeana.cloud.service.dps.status.DpsErrorCode;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

/*
 * Exception performing whole class analysis ignored.
 */
public class UnitedExceptionMapper {
    static final int UNPROCESSABLE_ENTITY = 422;
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitedExceptionMapper.class);

    public Response toResponse(TopologyAlreadyExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (DpsErrorCode)DpsErrorCode.TOPOLOGY_ALREADY_EXIST, (Exception)exception);
    }

    public Response toResponse(RuntimeException exception) {
        if (exception instanceof AccessDeniedException) {
            return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (DpsErrorCode)DpsErrorCode.ACCESS_DENIED_OR_OBJECT_DOES_NOT_EXIST_EXCEPTION, (Exception)exception);
        }
        LOGGER.error("Unexpected error occured.", (Throwable)exception);
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (DpsErrorCode)DpsErrorCode.OTHER, (Exception)exception);
    }

    public Response toResponse(WebApplicationException exception) {
        return UnitedExceptionMapper.buildResponse((int)exception.getResponse().getStatus(), (DpsErrorCode)DpsErrorCode.OTHER, (Exception)exception);
    }

    private static Response buildResponse(Response.Status httpStatus, DpsErrorCode errorCode, Exception e) {
        return UnitedExceptionMapper.buildResponse((int)httpStatus.getStatusCode(), (DpsErrorCode)errorCode, (Exception)e);
    }

    private static Response buildResponse(int httpStatusCode, DpsErrorCode errorCode, Exception e) {
        return Response.status((int)httpStatusCode).type("application/xml").entity((Object)new ErrorInfo(errorCode.name(), e.getMessage())).build();
    }
}

