/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.TaskExecutionReportService;
import eu.europeana.cloud.service.dps.TaskExecutionSubmitService;
import eu.europeana.cloud.service.dps.exception.AccessDeniedOrObjectDoesNotExistException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/topologies/{topologyName}/tasks")
@Component
public class TopologyTasksResource {
    @Autowired
    private TaskExecutionReportService reportService;
    @Autowired
    private TaskExecutionSubmitService submitService;
    @Autowired
    private MutableAclService mutableAclService;
    private static final String TOPOLOGY_PREFIX = "Topology";
    private static final String TASK_PREFIX = "DPS_Task";
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyTasksResource.class);

    @GET
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{taskId}")
    public DpsTask getTask(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) {
        LOGGER.info("Fetching task");
        DpsTask task = this.submitService.fetchTask(topologyName, Long.valueOf(taskId).longValue());
        return task;
    }

    @GET
    @Path(value="{taskId}/progress")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    @ReturnType(value="java.lang.String")
    public Response getTaskProgress(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId) throws AccessDeniedOrObjectDoesNotExistException {
        String progress = this.reportService.getTaskProgress(taskId);
        return Response.ok((Object)progress).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @PreAuthorize(value="hasPermission(#topologyName,'Topology', write)")
    @Path(value="/")
    public Response submitTask(DpsTask task, @PathParam(value="topologyName") String topologyName, @Context UriInfo uriInfo) {
        LOGGER.info("Submiting task");
        if (task != null) {
            this.submitService.submitTask(task, topologyName);
            this.grantPermissionsForTask(task.getTaskId() + "");
            String createdTaskUrl = this.buildTaskUrl(uriInfo, task, topologyName);
            try {
                LOGGER.info("Task submitted succesfully");
                return Response.created((URI)new URI(createdTaskUrl)).build();
            }
            catch (URISyntaxException e) {
                LOGGER.error("Task submition failed");
                e.printStackTrace();
                return Response.serverError().build();
            }
        }
        return Response.notModified().build();
    }

    @GET
    @Path(value="{taskId}/notification")
    @PreAuthorize(value="hasPermission(#taskId,'DPS_Task', read)")
    public String getTaskNotification(@PathParam(value="taskId") String taskId) {
        String progress = this.reportService.getTaskNotification(taskId);
        return progress;
    }

    @POST
    @Path(value="{taskId}/permit")
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @ReturnType(value="java.lang.Void")
    public Response grantPermissions(@PathParam(value="topologyName") String topologyName, @PathParam(value="taskId") String taskId, @FormParam(value="username") String username) {
        if (taskId != null && topologyName != null) {
            this.grantPermissionsForTask(taskId, username);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    private void grantPermissionsForTask(String taskId) {
        this.grantPermissionsForTask(taskId, SpringUserUtils.getUsername());
    }

    private void grantPermissionsForTask(String taskId, String username) {
        MutableAcl taskAcl = null;
        ObjectIdentityImpl taskObjectIdentity = new ObjectIdentityImpl(TASK_PREFIX, (Serializable)((Object)taskId));
        try {
            taskAcl = (MutableAcl)this.mutableAclService.readAclById((ObjectIdentity)taskObjectIdentity);
        }
        catch (NotFoundException e) {
            taskAcl = this.mutableAclService.createAcl((ObjectIdentity)taskObjectIdentity);
        }
        List obj = taskAcl.getEntries();
        taskAcl.insertAce(taskAcl.getEntries().size(), BasePermission.WRITE, (Sid)new PrincipalSid(username), true);
        taskAcl.insertAce(taskAcl.getEntries().size(), BasePermission.READ, (Sid)new PrincipalSid(username), true);
        this.mutableAclService.updateAcl(taskAcl);
    }

    private String buildTaskUrl(UriInfo uriInfo, DpsTask task, String topologyName) {
        StringBuilder taskUrl = new StringBuilder().append(uriInfo.getBaseUri().toString()).append("topologies/").append(topologyName).append("/tasks/").append(task.getTaskId());
        return taskUrl.toString();
    }
}

