/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.rest;

import eu.europeana.cloud.service.dps.TaskExecutionReportService;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/topologies/{topologyName}")
@Component
public class TopologiesResource {
    @Autowired
    private TaskExecutionReportService dps;
    @Autowired
    private MutableAclService mutableAclService;
    private static final String TOPOLOGY_PREFIX = "Topology";
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologiesResource.class);

    @Path(value="/permit")
    @POST
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response grantPermissionsToTopology(@FormParam(value="username") String userName, @PathParam(value="topologyName") String topology) {
        ObjectIdentityImpl topologyIdentity = new ObjectIdentityImpl(TOPOLOGY_PREFIX, (Serializable)((Object)topology));
        MutableAcl topologyAcl = null;
        try {
            topologyAcl = (MutableAcl)this.mutableAclService.readAclById((ObjectIdentity)topologyIdentity);
        }
        catch (Exception e) {
            LOGGER.info("ACL not found for topology {} and user {}. This is ok if it is the first time you are trying to assign permissions for this topology.", (Object)topology, (Object)userName);
            topologyAcl = this.mutableAclService.createAcl((ObjectIdentity)topologyIdentity);
        }
        topologyAcl.insertAce(topologyAcl.getEntries().size(), BasePermission.WRITE, (Sid)new PrincipalSid(userName), true);
        this.mutableAclService.updateAcl(topologyAcl);
        return Response.ok().build();
    }
}

