/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.util.FastByteArrayOutputStream;

public class ContentCachingResponseWrapper
extends HttpServletResponseWrapper {
    private final FastByteArrayOutputStream content = new FastByteArrayOutputStream(1024);
    @Nullable
    private ServletOutputStream outputStream;
    @Nullable
    private PrintWriter writer;
    @Nullable
    private Integer contentLength;
    @Nullable
    private String contentType;

    public ContentCachingResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void sendError(int sc) throws IOException {
        this.copyBodyToResponse(false);
        try {
            super.sendError(sc);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
    }

    public void sendError(int sc, String msg) throws IOException {
        this.copyBodyToResponse(false);
        try {
            super.sendError(sc, msg);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
    }

    public void sendRedirect(String location) throws IOException {
        this.copyBodyToResponse(false);
        super.sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ResponseServletOutputStream(this.getResponse().getOutputStream());
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            String characterEncoding = this.getCharacterEncoding();
            this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
    }

    public void setContentLength(int len) {
        if (len > this.content.size()) {
            this.content.resize(len);
        }
        this.contentLength = len;
    }

    public void setContentLengthLong(long len) {
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Content-Length exceeds ContentCachingResponseWrapper's maximum (2147483647): " + len);
        }
        int lenInt = (int)len;
        if (lenInt > this.content.size()) {
            this.content.resize(lenInt);
        }
        this.contentLength = lenInt;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public boolean containsHeader(String name) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return this.contentLength != null;
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            return this.contentType != null;
        }
        return super.containsHeader(name);
    }

    public void setHeader(String name, String value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.contentLength = Integer.valueOf(value);
        } else if ("Content-Type".equalsIgnoreCase(name)) {
            this.contentType = value;
        } else {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.contentLength = Integer.valueOf(value);
        } else if ("Content-Type".equalsIgnoreCase(name)) {
            this.contentType = value;
        } else {
            super.addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.contentLength = value;
        } else {
            super.setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            this.contentLength = value;
        } else {
            super.addIntHeader(name, value);
        }
    }

    @Nullable
    public String getHeader(String name) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return this.contentLength != null ? this.contentLength.toString() : null;
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            return this.contentType;
        }
        return super.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return this.contentLength != null ? Collections.singleton(this.contentLength.toString()) : Collections.emptySet();
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            return this.contentType != null ? Collections.singleton(this.contentType) : Collections.emptySet();
        }
        return super.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        Collection headerNames = super.getHeaderNames();
        if (this.contentLength != null || this.contentType != null) {
            ArrayList<String> result = new ArrayList<String>(headerNames);
            if (this.contentLength != null) {
                result.add("Content-Length");
            }
            if (this.contentType != null) {
                result.add("Content-Type");
            }
            return result;
        }
        return headerNames;
    }

    public void setBufferSize(int size) {
        if (size > this.content.size()) {
            this.content.resize(size);
        }
    }

    public void resetBuffer() {
        this.content.reset();
    }

    public void reset() {
        super.reset();
        this.content.reset();
    }

    public byte[] getContentAsByteArray() {
        return this.content.toByteArray();
    }

    public InputStream getContentInputStream() {
        return this.content.getInputStream();
    }

    public int getContentSize() {
        return this.content.size();
    }

    public void copyBodyToResponse() throws IOException {
        this.copyBodyToResponse(true);
    }

    protected void copyBodyToResponse(boolean complete) throws IOException {
        if (this.content.size() > 0) {
            HttpServletResponse rawResponse = (HttpServletResponse)this.getResponse();
            if (!rawResponse.isCommitted()) {
                if (complete || this.contentLength != null) {
                    if (rawResponse.getHeader("Transfer-Encoding") == null) {
                        rawResponse.setContentLength(complete ? this.content.size() : this.contentLength.intValue());
                    }
                    this.contentLength = null;
                }
                if (complete || this.contentType != null) {
                    rawResponse.setContentType(this.contentType);
                    this.contentType = null;
                }
            }
            this.content.writeTo((OutputStream)rawResponse.getOutputStream());
            this.content.reset();
            if (complete) {
                super.flushBuffer();
            }
        }
    }

    private class ResponseServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream os;

        public ResponseServletOutputStream(ServletOutputStream os) {
            this.os = os;
        }

        public void write(int b) throws IOException {
            ContentCachingResponseWrapper.this.content.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            ContentCachingResponseWrapper.this.content.write(b, off, len);
        }

        public boolean isReady() {
            return this.os.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.os.setWriteListener(writeListener);
        }
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
            super(new OutputStreamWriter((OutputStream)ContentCachingResponseWrapper.this.content, characterEncoding));
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
        }

        @Override
        public void write(String s2, int off, int len) {
            super.write(s2, off, len);
            super.flush();
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
        }
    }
}

