/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.context.MessageSource;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.method.MethodValidator;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.ModelAndViewContainer;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private static final ReflectionUtils.MethodFilter boxImplFilter = method -> method.isSynthetic() && Modifier.isStatic(method.getModifiers()) && method.getName().equals("box-impl");
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    @Nullable
    private WebDataBinderFactory dataBinderFactory;
    @Nullable
    private MethodValidator methodValidator;
    private Class<?>[] validationGroups = EMPTY_GROUPS;

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean2, Method method) {
        super(bean2, method);
    }

    protected InvocableHandlerMethod(Object bean2, Method method, @Nullable MessageSource messageSource) {
        super(bean2, method, messageSource);
    }

    public InvocableHandlerMethod(Object bean2, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean2, methodName, parameterTypes);
    }

    public void setHandlerMethodArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.resolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setDataBinderFactory(WebDataBinderFactory dataBinderFactory) {
        this.dataBinderFactory = dataBinderFactory;
    }

    public void setMethodValidator(@Nullable MethodValidator methodValidator) {
        this.methodValidator = methodValidator;
        this.validationGroups = methodValidator != null ? methodValidator.determineValidationGroups(this.getBean(), this.getBridgedMethod()) : EMPTY_GROUPS;
    }

    @Nullable
    public Object invokeForRequest(NativeWebRequest request, @Nullable ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object[] args = this.getMethodArgumentValues(request, mavContainer, providedArgs);
        if (logger.isTraceEnabled()) {
            logger.trace("Arguments: " + Arrays.toString(args));
        }
        if (this.shouldValidateArguments() && this.methodValidator != null) {
            this.methodValidator.applyArgumentValidation(this.getBean(), this.getBridgedMethod(), this.getMethodParameters(), args, this.validationGroups);
        }
        Object returnValue = this.doInvoke(args);
        if (this.shouldValidateReturnValue() && this.methodValidator != null) {
            this.methodValidator.applyReturnValueValidation(this.getBean(), this.getBridgedMethod(), this.getReturnType(), returnValue, this.validationGroups);
        }
        return returnValue;
    }

    protected Object[] getMethodArgumentValues(NativeWebRequest request, @Nullable ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object[] parameters = this.getMethodParameters();
        if (ObjectUtils.isEmpty(parameters)) {
            return EMPTY_ARGS;
        }
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            ((MethodParameter)parameter).initParameterNameDiscovery(this.parameterNameDiscoverer);
            args[i] = InvocableHandlerMethod.findProvidedArgument((MethodParameter)parameter, providedArgs);
            if (args[i] != null) continue;
            if (!this.resolvers.supportsParameter((MethodParameter)parameter)) {
                throw new IllegalStateException(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, "No suitable resolver"));
            }
            try {
                args[i] = this.resolvers.resolveArgument((MethodParameter)parameter, mavContainer, request, this.dataBinderFactory);
                continue;
            }
            catch (Exception ex) {
                String exMsg;
                if (logger.isDebugEnabled() && (exMsg = ex.getMessage()) != null && !exMsg.contains(((MethodParameter)parameter).getExecutable().toGenericString())) {
                    logger.debug(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, exMsg));
                }
                throw ex;
            }
        }
        return args;
    }

    @Nullable
    protected Object doInvoke(Object ... args) throws Exception {
        Method method = this.getBridgedMethod();
        try {
            if (KotlinDetector.isKotlinReflectPresent()) {
                if (KotlinDetector.isSuspendingFunction(method)) {
                    return this.invokeSuspendingFunction(method, this.getBean(), args);
                }
                if (KotlinDetector.isKotlinType(method.getDeclaringClass())) {
                    return KotlinDelegate.invokeFunction(method, this.getBean(), args);
                }
            }
            return method.invoke(this.getBean(), args);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(method, this.getBean(), args);
            String text = ex.getMessage() == null || ex.getCause() instanceof NullPointerException ? "Illegal argument" : ex.getMessage();
            throw new IllegalStateException(this.formatInvokeError(text, args), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getCause();
            if (targetException instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)targetException;
                throw runtimeException;
            }
            if (targetException instanceof Error) {
                Error error = (Error)targetException;
                throw error;
            }
            if (targetException instanceof Exception) {
                Exception exception = (Exception)targetException;
                throw exception;
            }
            throw new IllegalStateException(this.formatInvokeError("Invocation failure", args), targetException);
        }
    }

    protected Object invokeSuspendingFunction(Method method, Object target, Object[] args) {
        return CoroutinesUtils.invokeSuspendingFunction(method, target, args);
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        @Nullable
        public static Object invokeFunction(Method method, Object target, Object[] args) throws InvocationTargetException, IllegalAccessException {
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
            if (function == null) {
                return method.invoke(target, args);
            }
            if (method.isAccessible() && !KCallablesJvm.isAccessible((KCallable)function)) {
                KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
            }
            HashMap<KParameter, Object> argMap = CollectionUtils.newHashMap(args.length + 1);
            int index = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case INSTANCE: {
                        argMap.put(parameter, target);
                        break;
                    }
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        if (!parameter.isOptional() || args[index] != null) {
                            KClass kClass;
                            KClassifier kClassifier = parameter.getType().getClassifier();
                            if (kClassifier instanceof KClass && (kClass = (KClass)kClassifier).isValue()) {
                                Class javaClass = JvmClassMappingKt.getJavaClass((KClass)kClass);
                                Method[] methods = ReflectionUtils.getUniqueDeclaredMethods(javaClass, boxImplFilter);
                                Assert.state(methods.length == 1, "Unable to find a single box-impl synthetic static method in " + javaClass.getName());
                                argMap.put(parameter, ReflectionUtils.invokeMethod(methods[0], null, args[index]));
                            } else {
                                argMap.put(parameter, args[index]);
                            }
                        }
                        ++index;
                    }
                }
            }
            Object result = function.callBy(argMap);
            return result == Unit.INSTANCE ? null : result;
        }
    }
}

