/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.web.server.authorization.HttpStatusServerAccessDeniedHandler;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.csrf.CsrfException;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestHandler;
import org.springframework.security.web.server.csrf.WebSessionServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.XorServerCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CsrfWebFilter
implements WebFilter {
    public static final ServerWebExchangeMatcher DEFAULT_CSRF_MATCHER = new DefaultRequireCsrfProtectionMatcher();
    private static final String SHOULD_NOT_FILTER = "SHOULD_NOT_FILTER" + CsrfWebFilter.class.getName();
    private ServerWebExchangeMatcher requireCsrfProtectionMatcher = DEFAULT_CSRF_MATCHER;
    private ServerCsrfTokenRepository csrfTokenRepository = new WebSessionServerCsrfTokenRepository();
    private ServerAccessDeniedHandler accessDeniedHandler = new HttpStatusServerAccessDeniedHandler(HttpStatus.FORBIDDEN);
    private ServerCsrfTokenRequestHandler requestHandler = new XorServerCsrfTokenRequestAttributeHandler();

    public void setAccessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
        Assert.notNull((Object)accessDeniedHandler, "accessDeniedHandler");
        this.accessDeniedHandler = accessDeniedHandler;
    }

    public void setCsrfTokenRepository(ServerCsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, "csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
    }

    public void setRequireCsrfProtectionMatcher(ServerWebExchangeMatcher requireCsrfProtectionMatcher) {
        Assert.notNull((Object)requireCsrfProtectionMatcher, "requireCsrfProtectionMatcher cannot be null");
        this.requireCsrfProtectionMatcher = requireCsrfProtectionMatcher;
    }

    public void setRequestHandler(ServerCsrfTokenRequestHandler requestHandler) {
        Assert.notNull((Object)requestHandler, "requestHandler cannot be null");
        this.requestHandler = requestHandler;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        if (Boolean.TRUE.equals(exchange2.getAttribute(SHOULD_NOT_FILTER))) {
            return chain.filter(exchange2).then(Mono.empty());
        }
        return this.requireCsrfProtectionMatcher.matches(exchange2).filter(ServerWebExchangeMatcher.MatchResult::isMatch).filter(matchResult -> !exchange2.getAttributes().containsKey(CsrfToken.class.getName())).flatMap(m4 -> this.validateToken(exchange2)).flatMap(m4 -> this.continueFilterChain(exchange2, chain)).switchIfEmpty(this.continueFilterChain(exchange2, chain).then(Mono.empty())).onErrorResume(CsrfException.class, ex -> this.accessDeniedHandler.handle(exchange2, (AccessDeniedException)ex));
    }

    public static void skipExchange(ServerWebExchange exchange2) {
        exchange2.getAttributes().put(SHOULD_NOT_FILTER, Boolean.TRUE);
    }

    private Mono<Void> validateToken(ServerWebExchange exchange2) {
        return this.csrfTokenRepository.loadToken(exchange2).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new CsrfException("An expected CSRF token cannot be found")))).filterWhen(expected -> this.containsValidCsrfToken(exchange2, (CsrfToken)expected)).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new CsrfException("Invalid CSRF Token")))).then();
    }

    private Mono<Boolean> containsValidCsrfToken(ServerWebExchange exchange2, CsrfToken expected) {
        return this.requestHandler.resolveCsrfTokenValue(exchange2, expected).map(actual -> CsrfWebFilter.equalsConstantTime(actual, expected.getToken()));
    }

    private Mono<Void> continueFilterChain(ServerWebExchange exchange2, WebFilterChain chain) {
        return Mono.defer(() -> {
            Mono<CsrfToken> csrfToken = this.csrfToken(exchange2);
            this.requestHandler.handle(exchange2, csrfToken);
            return chain.filter(exchange2);
        });
    }

    private Mono<CsrfToken> csrfToken(ServerWebExchange exchange2) {
        return this.csrfTokenRepository.loadToken(exchange2).switchIfEmpty(this.generateToken(exchange2));
    }

    private static boolean equalsConstantTime(String expected, String actual) {
        if (expected == actual) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        byte[] expectedBytes = Utf8.encode(expected);
        byte[] actualBytes = Utf8.encode(actual);
        return MessageDigest.isEqual(expectedBytes, actualBytes);
    }

    private Mono<CsrfToken> generateToken(ServerWebExchange exchange2) {
        return this.csrfTokenRepository.generateToken(exchange2).delayUntil(token -> this.csrfTokenRepository.saveToken(exchange2, (CsrfToken)token)).cache();
    }

    private static class DefaultRequireCsrfProtectionMatcher
    implements ServerWebExchangeMatcher {
        private static final Set<HttpMethod> ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.TRACE, HttpMethod.OPTIONS));

        private DefaultRequireCsrfProtectionMatcher() {
        }

        @Override
        public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange2) {
            return Mono.just((Object)exchange2.getRequest()).flatMap(r -> Mono.justOrEmpty((Object)r.getMethod())).filter(ALLOWED_METHODS::contains).flatMap(m4 -> ServerWebExchangeMatcher.MatchResult.notMatch()).switchIfEmpty(ServerWebExchangeMatcher.MatchResult.match());
        }
    }
}

