/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerX509AuthenticationConverter
implements ServerAuthenticationConverter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final X509PrincipalExtractor principalExtractor;

    public ServerX509AuthenticationConverter(@NonNull X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }

    @Override
    public Mono<Authentication> convert(ServerWebExchange exchange2) {
        SslInfo sslInfo = exchange2.getRequest().getSslInfo();
        if (sslInfo == null) {
            this.logger.debug("No SslInfo provided with a request, skipping x509 authentication");
            return Mono.empty();
        }
        if (sslInfo.getPeerCertificates() == null || sslInfo.getPeerCertificates().length == 0) {
            this.logger.debug("No peer certificates found in SslInfo, skipping x509 authentication");
            return Mono.empty();
        }
        X509Certificate clientCertificate = sslInfo.getPeerCertificates()[0];
        Object principal2 = this.principalExtractor.extractPrincipal(clientCertificate);
        return Mono.just((Object)new PreAuthenticatedAuthenticationToken(principal2, clientCertificate));
    }
}

