/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.Assert;

public class AuthenticationEntryPointFailureHandler
implements AuthenticationFailureHandler {
    private boolean rethrowAuthenticationServiceException = true;
    private final AuthenticationEntryPoint authenticationEntryPoint;

    public AuthenticationEntryPointFailureHandler(AuthenticationEntryPoint authenticationEntryPoint) {
        Assert.notNull((Object)authenticationEntryPoint, "authenticationEntryPoint cannot be null");
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (!this.rethrowAuthenticationServiceException) {
            this.authenticationEntryPoint.commence(request, response, exception);
            return;
        }
        if (!AuthenticationServiceException.class.isAssignableFrom(exception.getClass())) {
            this.authenticationEntryPoint.commence(request, response, exception);
            return;
        }
        throw exception;
    }

    public void setRethrowAuthenticationServiceException(boolean rethrowAuthenticationServiceException) {
        this.rethrowAuthenticationServiceException = rethrowAuthenticationServiceException;
    }
}

