/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Deprecated
final class ProtectPointcutPostProcessor
implements BeanPostProcessor {
    private static final Log logger = LogFactory.getLog(ProtectPointcutPostProcessor.class);
    private final Map<String, List<ConfigAttribute>> pointcutMap = new LinkedHashMap<String, List<ConfigAttribute>>();
    private final MapBasedMethodSecurityMetadataSource mapBasedMethodSecurityMetadataSource;
    private final Set<PointcutExpression> pointCutExpressions = new LinkedHashSet<PointcutExpression>();
    private final PointcutParser parser;
    private final Set<String> processedBeans = new HashSet<String>();

    ProtectPointcutPostProcessor(MapBasedMethodSecurityMetadataSource mapBasedMethodSecurityMetadataSource) {
        Assert.notNull((Object)mapBasedMethodSecurityMetadataSource, "MapBasedMethodSecurityMetadataSource to populate is required");
        this.mapBasedMethodSecurityMetadataSource = mapBasedMethodSecurityMetadataSource;
        HashSet<PointcutPrimitive> supportedPrimitives = new HashSet<PointcutPrimitive>(3);
        supportedPrimitives.add(PointcutPrimitive.EXECUTION);
        supportedPrimitives.add(PointcutPrimitive.ARGS);
        supportedPrimitives.add(PointcutPrimitive.REFERENCE);
        this.parser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution(supportedPrimitives);
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (this.processedBeans.contains(beanName)) {
            return bean2;
        }
        Set<String> set = this.processedBeans;
        synchronized (set) {
            Method[] methods;
            if (this.processedBeans.contains(beanName)) {
                return bean2;
            }
            block3: for (Method method : methods = this.getBeanMethods(bean2)) {
                for (PointcutExpression expression : this.pointCutExpressions) {
                    if (!this.attemptMatch(bean2.getClass(), method, expression, beanName)) continue;
                    continue block3;
                }
            }
            this.processedBeans.add(beanName);
        }
        return bean2;
    }

    private Method[] getBeanMethods(Object bean2) {
        try {
            return bean2.getClass().getMethods();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    private boolean attemptMatch(Class<?> targetClass, Method method, PointcutExpression expression, String beanName) {
        boolean matches = expression.matchesMethodExecution(method).alwaysMatches();
        if (matches) {
            List<ConfigAttribute> attr = this.pointcutMap.get(expression.getPointcutExpression());
            if (logger.isDebugEnabled()) {
                logger.debug("AspectJ pointcut expression '" + expression.getPointcutExpression() + "' matches target class '" + targetClass.getName() + "' (bean ID '" + beanName + "') for method '" + method + "'; registering security configuration attribute '" + attr + "'");
            }
            this.mapBasedMethodSecurityMetadataSource.addSecureMethod(targetClass, method, attr);
        }
        return matches;
    }

    public void setPointcutMap(Map<String, List<ConfigAttribute>> map) {
        Assert.notEmpty(map, "configAttributes cannot be empty");
        for (String expression : map.keySet()) {
            List<ConfigAttribute> value = map.get(expression);
            this.addPointcut(expression, value);
        }
    }

    private void addPointcut(String pointcutExpression, List<ConfigAttribute> definition) {
        Assert.hasText(pointcutExpression, "An AspectJ pointcut expression is required");
        Assert.notNull(definition, "A List of ConfigAttributes is required");
        pointcutExpression = this.replaceBooleanOperators(pointcutExpression);
        this.pointcutMap.put(pointcutExpression, definition);
        this.pointCutExpressions.add(this.parser.parsePointcutExpression(pointcutExpression));
        if (logger.isDebugEnabled()) {
            logger.debug("AspectJ pointcut expression '" + pointcutExpression + "' registered for security configuration attribute '" + definition + "'");
        }
    }

    private String replaceBooleanOperators(String pcExpr) {
        pcExpr = StringUtils.replace(pcExpr, " and ", " && ");
        pcExpr = StringUtils.replace(pcExpr, " or ", " || ");
        pcExpr = StringUtils.replace(pcExpr, " not ", " ! ");
        return pcExpr;
    }
}

