/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;

class AspectJMethodMatcher
implements MethodMatcher,
ClassFilter,
Pointcut {
    private static final PointcutParser parser;
    private final PointcutExpression expression;

    AspectJMethodMatcher(String expression) {
        this.expression = parser.parsePointcutExpression(expression);
    }

    @Override
    public boolean matches(Class<?> clazz) {
        return this.expression.couldMatchJoinPointsInType(clazz);
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        return this.expression.matchesMethodExecution(method).alwaysMatches();
    }

    @Override
    public boolean isRuntime() {
        return false;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass, Object ... args) {
        return this.matches(method, targetClass);
    }

    @Override
    public ClassFilter getClassFilter() {
        return this;
    }

    @Override
    public MethodMatcher getMethodMatcher() {
        return this;
    }

    static {
        HashSet<PointcutPrimitive> supportedPrimitives = new HashSet<PointcutPrimitive>(3);
        supportedPrimitives.add(PointcutPrimitive.EXECUTION);
        supportedPrimitives.add(PointcutPrimitive.ARGS);
        supportedPrimitives.add(PointcutPrimitive.REFERENCE);
        parser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution(supportedPrimitives);
    }
}

