/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class OAuth2ClientBeanDefinitionParserUtils {
    private static final String ATT_CLIENT_REGISTRATION_REPOSITORY_REF = "client-registration-repository-ref";
    private static final String ATT_AUTHORIZED_CLIENT_REPOSITORY_REF = "authorized-client-repository-ref";
    private static final String ATT_AUTHORIZED_CLIENT_SERVICE_REF = "authorized-client-service-ref";

    private OAuth2ClientBeanDefinitionParserUtils() {
    }

    static BeanMetadataElement getClientRegistrationRepository(Element element) {
        String clientRegistrationRepositoryRef = element.getAttribute(ATT_CLIENT_REGISTRATION_REPOSITORY_REF);
        if (StringUtils.hasLength(clientRegistrationRepositoryRef)) {
            return new RuntimeBeanReference(clientRegistrationRepositoryRef);
        }
        return new RuntimeBeanReference(ClientRegistrationRepository.class);
    }

    static BeanMetadataElement getAuthorizedClientRepository(Element element) {
        String authorizedClientRepositoryRef = element.getAttribute(ATT_AUTHORIZED_CLIENT_REPOSITORY_REF);
        if (StringUtils.hasLength(authorizedClientRepositoryRef)) {
            return new RuntimeBeanReference(authorizedClientRepositoryRef);
        }
        return null;
    }

    static BeanMetadataElement getAuthorizedClientService(Element element) {
        String authorizedClientServiceRef = element.getAttribute(ATT_AUTHORIZED_CLIENT_SERVICE_REF);
        if (StringUtils.hasLength(authorizedClientServiceRef)) {
            return new RuntimeBeanReference(authorizedClientServiceRef);
        }
        return null;
    }

    static BeanDefinition createDefaultAuthorizedClientRepository(BeanMetadataElement clientRegistrationRepository, BeanMetadataElement authorizedClientService) {
        if (authorizedClientService == null) {
            authorizedClientService = BeanDefinitionBuilder.rootBeanDefinition("org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService").addConstructorArgValue(clientRegistrationRepository).getBeanDefinition();
        }
        return BeanDefinitionBuilder.rootBeanDefinition("org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository").addConstructorArgValue(authorizedClientService).getBeanDefinition();
    }
}

